<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

require_once APPPATH.'modules/generic/models/Mdl_generic.php';

class Mdl_admin extends Mdl_generic {

  var $table = 'admin_master';
  var $column_order = array(null,'name','username','pword','status'); 
  var $column_search = array('name','username','status'); 
  var $order = array("createdDate" => "asc"); 

  function __construct() {
    parent::__construct();
  }
  
  private function _get_datatables_query(){
    if($this->input->post('status')){
      $this->db->where('status', $this->input->post('status'));
    }

    $this->db->from($this->table);
    $i = 0;
  
    foreach ($this->column_search as $item){
      if($_POST['search']['value']){
        
        if($i===0){
          $this->db->group_start(); 
          $this->db->like($item, $_POST['search']['value']);
        }else{
          $this->db->or_like($item, $_POST['search']['value']);
        }

        if(count($this->column_search) - 1 == $i) 
          $this->db->group_end(); 
      }
      $i++;
    }
    
    if(isset($_POST['order'])){
      $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
    }else if(isset($this->order)){
      $order = $this->order;
      $this->db->order_by(key($order), $order[key($order)]);
    }
  }

  public function get_datatables(){
    $this->_get_datatables_query();
    if($_POST['length'] != -1)
    $this->db->limit($_POST['length'], $_POST['start']);
    $query = $this->db->get();
    return $query->result();
  }

  public function count_filtered(){
    $this->_get_datatables_query();
    $query = $this->db->get();
    return $query->num_rows();
  }

  public function count_all(){
    $this->db->from($this->table);
    return $this->db->count_all_results();
  }
}