<?php 
namespace App\Modules\Faq\Controllers;
ini_set("memory_limit","512M");
error_reporting(E_ALL ^ E_NOTICE);



use App\Modules\generic\Models\Mdl_generic;

use App\Modules\Faq\Models\Mdl_faq;

use CodeIgniter\Controller;

class Faq extends Controller
{
   private $db;
 protected  $viewFile;
 protected  $email;
 protected  $captcha; 
 protected  $isLogin;
 
    /**
     * Constructor.
     */
    public function __construct()
    {
        //$db = \Config\Database::connect();
        $this->Mdl_faq = new Mdl_faq();
    }

  function index(){
    $statement = 'SELECT * FROM faq WHERE status = "1" ORDER BY createdDate desc';
    $result = $this->Mdl_faq->customQuery($statement);

    $data['faq'] = $result;
    $data['seo'] = $this->Mdl_faq->getByValue("seo","page","home");
    $data['country'] = $this->Mdl_faq->getAllRecords("country");
    $data['viewFile'] = "faq/faq";
    $data['scriptFile'] = "faq";
    $data['module'] = "faq";
    $template = 'home';
    return view('template/'.$template, $data);
  }

	/*************************************************************************/
	/* 														ADMIN MODULE															 */
	/*************************************************************************/
	
	/*
	**	FAQ LISTING PAGE
	*/
	function viewall(){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }

    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);

    if(! in_array("7.1",$rights)){
      redirect('admin/dashboard','refresh');
    }

    $template = 'admin';
    $data['scriptFile'] = 'admin-faq_v_1.0';
    $data['viewFile'] = 'faq/list-faq';
    $data['module'] = "faq";
    return view('template/'.$template, $data);
  }
	
	/*
  **  GET LIST OF FAQ
  */
  function getFaq(){
    $list = $this->Mdl_faq->get_datatables();
    $data = array();
    $no = $_POST['start']; 
    $admin = $this->session->userdata('admin');

    #track log
    $admin_array['userid'] = $admin['id'];
    $admin_array['usertype'] = 'admin';
    $admin_array['action_type'] = 'View';
    $admin_array['modulename'] = 'FAQ';
    $admin_array['userip'] = $this->input->ip_address();
    $admin_array['logID'] = $admin['logID'];

    $log =  insertTrackLog($admin_array);

    foreach ($list as $val) {
      $row = array();
      $url = base_url().'faq/update/'.$val->id;
      $row[] = '<a class="btn btn-rounded btn-outline-success" href="'.$url.'">UPDATE</a>';
      
      if($admin['isAdmin'] !== '1'){
        $row[] = '<button class="btn btn-block btn-rounded btn-outline-danger" id="'.$val->id.'" onclick="callDeleteFunction(\'faq\',\'id\',this.id,\'faq\')">DELETE</button>';
      }else{
        $row[] = '';
      }

      $row[] = $val->title;
      
      $pdf_url = base_url().$val->filepath;
      $row[] = '<a class="btn btn-rounded btn-outline-info" target="_blank" href="'.$pdf_url.'"><i class="fa fa-file-pdf-o" aria-hidden="true"> VIEW </i></a>';

			if($val->status == '1'){
        $status = '<span class="badge badge-success">ACTIVE</span>';
      }else{
        $status = '<span class="badge badge-danger">DEACTIVE</span>';
      }
      $row[] = $status;
      $row[] = strtoupper($val->admin);
      $row[] = date('d-m-Y',strtotime($val->modifiedDate));
      $data[] = $row;
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Mdl_faq->count_all(),
      "recordsFiltered" => $this->Mdl_faq->count_filtered(),
      "data" => $data,
    );

    echo json_encode($output);
	}
	
  /*
  ** ADD NEW FAQ
  */
  function add(){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }

    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);

    if(! in_array("7.2",$rights)){
      redirect('admin/dashboard','refresh');
    }
    
    $data['viewFile'] = "faq/add-faq";
    $data['scriptFile'] = "admin-faq_v_1.0";
    $data['module'] = "faq";
    $template = 'admin';
    return view('template/'.$template, $data);
  }

  /*
  ** ADD FAQ ACTION
  */
  function addFAQAction(){
    $content = $this->input->post();

    $this->form_validation->set_rules("title","title","trim|required|xss_clean|max_length[100]",
    array(
      'required' => 'Title is required.',
      'max_length' => 'Title is invalid.'
    ));

    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors);
    }else{
      if(!empty($_FILES['pdf']['name'])){
        $filename = $_FILES['pdf']['name'];
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        $imagename = strtotime('now');
        $img = $this->uploadFile($imagename,"pdf");
        $imgpath = 'public/custom/files/faq/'.$imagename.'.'.$ext;
        if($img !== 1){
          echo json_encode(array("pdf"=>$img)); exit;
        }
      }else{
        echo json_encode(array("pdf"=>"Please upload file")); exit;
      }

      $admin = $this->session->userdata('admin');

      $data = array(
        'title'=> strip_tags($content['title']),
        'filepath'=> strip_tags($imgpath),
        'status'=> '1',
        'admin'=>Modules::run('admin/getAdminName',$admin['id']),
        'createdDate'=>date('Y-m-d H:i:s'),
        'modifiedDate'=>date('Y-m-d H:i:s')
      );

      $insert = $this->Mdl_faq->insert("faq", $data);
$insertId = $this->db->insert_id();
      #track log
      $admin_array['userid'] = $admin['id'];
      $admin_array['usertype'] = 'admin';
      $admin_array['action_type'] = 'Insert';
      $admin_array['modulename'] = 'FAQ';
      $admin_array['event_id'] = $insertId;
      $admin_array['userip'] = $this->input->ip_address();
      $admin_array['logID'] = $admin['logID'];
      
      $log =  insertTrackLog($admin_array);

      echo json_encode(array("status"=>"success")); exit;
    }
  }
  
  /*
  ** UPDATE FAQ
  */
  function update($id){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }

    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);
    
    if(! in_array("7.3",$rights)){
      redirect('admin/dashboard','refresh');
    }

    $result = $this->Mdl_faq->getByValue("faq","id",$id);
    if($result == "No Data"){
      redirect('errors','refresh');
    }else{
      $data['faq'] = $result;
      $data['viewFile'] = "faq/update-faq";
      $data['scriptFile'] = "admin-faq_v_1.0";
      $data['module'] = "faq";
      $template = 'admin';
      return view('template/'.$template, $data);
    }
  }

  /*
  ** UPDATE FAQ ACTION
  */
  function updateFAQAction(){
    $content = $this->input->post();

    $this->form_validation->set_rules("title","title","trim|required|xss_clean|max_length[100]",
    array(
      'required' => 'Title is required.',
      'max_length' => 'Title is invalid.'
    ));

    $this->form_validation->set_rules("status","Status","trim|required|xss_clean|max_length[100]",
    array(
      'required' => 'Status is not selected.',
      'max_length' => 'Status is invalid.'
    ));

    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors);
    }else{
      if(!empty($_FILES['pdf']['name'])){
        if(file_exists('./'.$content['pdf_path'])){
          $this->removeImage($content['pdf_path']);
        }
        
        $filename = $_FILES['pdf']['name'];
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        $imagename = strtotime('now');
        $img = $this->uploadFile($imagename,"pdf");
        $imgpath = 'public/custom/files/faq/'.$imagename.'.'.$ext;
        if($img !== 1){
          echo json_encode(array("pdf"=>$img)); exit;
        }
      }else{
        $imgpath = $content['pdf_path'];
      }

      $admin = $this->session->userdata('admin');

      $data = array(
        'title'=> strip_tags($content['title']),
        'filepath'=> strip_tags($imgpath),
        'status'=> strip_tags($content['status']),
        'admin'=>Modules::run('admin/getAdminName',$admin['id']),
        'modifiedDate'=>date('Y-m-d H:i:s')
      );

      $insert = $this->Mdl_faq->update("faq", "id", $content['id'], $data);

      #track log
      $admin_array['userid'] = $admin['id'];
      $admin_array['usertype'] = 'admin';
      $admin_array['action_type'] = 'Update';
      $admin_array['modulename'] = 'FAQ';
      $admin_array['userip'] = $this->input->ip_address();
      $admin_array['logID'] = $admin['logID'];

      $log =  insertTrackLog($admin_array);

      echo json_encode(array("status"=>"success")); exit;
    }
  }

	/*
  **  File Upload
  */
  function uploadFile($imageName,$key){
    $config['file_name'] = $imageName;
    $config['upload_path'] = './public/custom/files/faq';
    $config['allowed_types'] = "pdf|PDF";
    $config['max_size']  = '5000';
    
    $this->load->library('upload',$config);
    $this->upload->initialize($config);
    if (!$this->upload->do_upload($key)){
      return $this->upload->display_errors();
    }else{
      return 1;
    }
  }
}
