<?php 
namespace App\Modules\Member\Controllers;
ini_set("memory_limit","512M");
error_reporting(E_ALL ^ E_NOTICE);



use App\Modules\generic\Models\Mdl_generic;

use App\Modules\Member\Models\Mdl_member;

use CodeIgniter\Controller;

class Member extends Controller
{
   private $db;
 protected  $viewFile;
 protected  $email;
 protected  $captcha; 
 protected  $isLogin;
 
    /**
     * Constructor.
     */
    public function __construct()
    {
        //$db = \Config\Database::connect();
        $this->Mdl_member = new Mdl_member();
    }

	/*
	**	NEW MEMBER PAGE
	*/
	function newMember(){				
		$template = 'home';
		$data['country'] = $this->Mdl_member->getAllRecords("country");
		$data['seo'] = $this->Mdl_member->getByValue("seo","page","home");
		$data['viewFile'] = 'member/new';
		$data['module'] = "member";
		return view('template/'.$template, $data); 
	}

	/*
	**	EXISTING MEMBER PAGE
	*/
	function existing(){				
		$template = 'home';
		$data['country'] = $this->Mdl_member->getAllRecords("country");
		$data['seo'] = $this->Mdl_member->getByValue("seo","page","home");
		$data['viewFile'] = 'member/existing';
		$data['module'] = "member";
		return view('template/'.$template, $data); 
	}

	/*
	**	MEMBER LOGIN PAGE
	*/
	function login(){			
		if($this->session->userdata('user')){
			redirect('/','refresh');
		}

		$this->session->set_userdata('referrer_url', $this->agent->referrer());  

		$template = 'home';
		$data['country'] = $this->Mdl_member->getAllRecords("country");
		$data['seo'] = $this->Mdl_member->getByValue("seo","page","home");
		$data['viewFile'] = 'member/login';
		$data['scriptFile'] = 'login';
		$data['module'] = "member";
		return view('template/'.$template, $data); 
	}

	/*
  **  OTP ACTION 
  */
  function generateOtp(){
    $content = $this->input->post();

    $this->form_validation->set_rules("isd","isd","trim|xss_clean|required",
    array(
      'required' => "required"
    ));

    if($content['isd'] == "91"){
      $this->form_validation->set_rules("mobile","Mobile Number","trim|required|xss_clean|exact_length[10]|integer",
      array(
        'required' => "Mobile is required",
        'integer' => "Mobile is invalid",
        'exact_length' => "Mobile is invalid"
      ));
    }else{
      $this->form_validation->set_rules("mobile","Mobile Number","trim|required|xss_clean|min_length[7]|max_length[15]|integer",
      array(
		'required' => "Mobile is required",
        'integer' => "Mobile is invalid",
        'min_length' => "Mobile is invalid",
        'max_length' => "Mobile is invalid"
      ));
    }


          $this->form_validation->set_rules("captcha","Captcha","trim|required|xss_clean",array(
      'required' => "Captcha is required."
    ));
    
    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors); exit;
    }
    else
    {
        
        $captcha_insert = $content['captcha'];
             $contain_sess_captcha = $this->session->userdata('valuecaptchaCode');

              if($captcha_insert != $contain_sess_captcha) {
        
                echo json_encode(array("status" => "CaptchaIncorrect")); 
                exit;
        
              } 
        $result = $this->memberLogin($content['username'], $content['userpassword'], $content['mobile']);
                    if($result == 1){
						echo json_encode(array("status"=>"invalid_member")); exit;
					}else{
						$directory = json_decode($result, true);
						if(!$directory){
							echo json_encode(array("status"=>"invalid_member")); exit;
						}
					

        
        
      $query = 'SELECT * FROM login_otp WHERE mobile = "'.$content['mobile'].'" ORDER BY createdDate desc LIMIT 1';
      $otp_rec = $this->Mdl_member->customQuery($query);

      $new = false;

      if($otp_rec == "No Data"){
        $new = true;  
      }
      //echo "test";
      /* $createdDate=$otp_rec[0]->createdDate;
       $modifiedDate=$otp_rec[0]->modifiedDate;
      if($modifiedDate !='' || $createdDate !='')
      {
           if($modifiedDate !='')
          {
            $old = strtotime(''.$modifiedDate.' +1 minutes');
          }
          else
          {
            $old = strtotime(''.$createdDate.' +1 minutes');
          }
          $new=strtotime(now);
           if($old > $new){
              echo json_encode(array("status"=>"error","msg"=>"Please wait for 1 minute before sending another otp.")); exit;
            } 
      }*/
        else{
      
      
       if($otp_rec[0]->is_blocked == '1'){
        if(strtotime(now) < strtotime($otp_rec[0]->block_till)){
          echo json_encode(array("status"=>"blocked")); exit;
        }else{
          $otp_data = array(
            "count" => 0,
            "is_blocked" => '0',
            "block_till" => date("Y-m-d H:i:s"),
            "modifiedDate" => date("Y-m-d H:i:s")
          );

          $update = $this->Mdl_member->update("login_otp", "id", $otp_rec[0]->id, $otp_data);
        } 
      }

      $otp = rand(1000,9999);

      $response = $this->sendSMS($content['isd'],$content['mobile'],$otp);

      if($response == '1'){
        echo json_encode(array("status"=>"error","msg"=>"Something went wrong. Please try again.")); exit;
      }else{
        $result = json_decode($response, true);

        if($result['type'] == "error"){
          echo json_encode(array("status"=>"error","msg"=>$result['message'])); exit;
        }else if($result['type'] == "success"){
          
          if($new){
            $otp_data = array(
              'mobile' => $content['mobile'],
              'otp' => $otp,
              "count" => 0,
              "is_blocked" => '0',
              "block_till" => date("Y-m-d H:i:s"),
              "createdDate" => date("Y-m-d H:i:s"),
              "modifiedDate" => date("Y-m-d H:i:s")
            );

            $insert = $this->Mdl_member->insert('login_otp',$otp_data);
          }else{
            $otp_data = array(
              'otp' => $otp,
              "modifiedDate" => date("Y-m-d H:i:s")
            );

            $update = $this->Mdl_member->update("login_otp", "id", $otp_rec[0]->id, $otp_data);
          }
          echo json_encode(array("status"=>"success")); exit;
        }
      }
      }
    }
    }
  }

  /*
  **  LOGIN ACTION 
  */
  function loginAction(){
		$content = $this->input->post();
		//echo "<pre>";
		// print_r($content);
		//die();
		 //exit;

    $this->form_validation->set_rules("username","Username","trim|required|xss_clean",
		array(
			'required' => "Username is required",
		));

		$this->form_validation->set_rules("userpassword","Password","trim|required|xss_clean",
		array(
			'required' => "Password is required",
		));
      
		$this->form_validation->set_rules("isd","isd","trim|xss_clean|required|integer",
		array(
			'required' => "Select Country",
			"integer" => "Invalid option"
		));

		if($content['isd'] == "91"){
			$this->form_validation->set_rules("mobile","Mobile Number","trim|required|xss_clean|exact_length[10]|integer",
			array(
				'required' => "Mobile Number is required",
				'integer' => "Mobile Number is invalid",
				'exact_length' => "Mobile Number is invalid"
			));
		}else{
			$this->form_validation->set_rules("mobile","Mobile Number","trim|required|xss_clean|min_length[7]|max_length[15]|integer",
			array(
				'required' => "Mobile Number is required",
				'integer' => "Mobile Number is invalid",
				'min_length' => "Mobile Number is invalid",
				'max_length' => "Mobile Number is invalid"
			));
		}
        
        
          $this->form_validation->set_rules("captcha","Captcha","trim|required|xss_clean",array(
      'required' => "Captcha is required."
    ));
    
	/*	if($content['otp'] !== ''){
			$this->form_validation->set_rules("otp","OTP","trim|required|xss_clean|exact_length[4]|integer",
			array(
				'required' => "OTP is required",
				'integer' => "OTP is invalid",
				'exact_length' => "OTP is invalid"
			));
		}
*/
    if($this->form_validation->run() == FALSE){
			$errors = $this->form_validation->error_array();
			echo json_encode($errors); exit;
		}else{
		    
		    
		     $captcha_insert = $content['captcha'];
             $contain_sess_captcha = $this->session->userdata('valuecaptchaCode');

              if($captcha_insert != $contain_sess_captcha) {
        
                echo json_encode(array("captcha" => "Captcha is Incorrect !")); 
                exit;
        
              }
              
              
			if($content['otp'] == ''){
				echo json_encode(array("status"=>"otp_missing")); exit;
			}else{
				$query = 'SELECT * FROM login_otp WHERE mobile = "'.$content['mobile'].'" ORDER BY createdDate desc LIMIT 1';
				$otp_rec = $this->Mdl_member->customQuery($query);
				
				//echo"databasedfata ".md5($otp_rec[0]->otp)."<br> data ".$content['otp'];
				if($otp_rec == "No Data"){
					echo json_encode(array("status"=>"otp_missing")); exit;
				}else if($otp_rec[0]->is_blocked == "1"){
					echo json_encode(array("status"=>"blocked")); exit;
				}
				//else if($otp_rec[0]->otp !== $content['otp']){
				//else if(md5($otp_rec[0]->otp) !== $content['otp']){
				else if(hash('sha256',$otp_rec[0]->otp) !== $content['otp']){
					$fail_count = $otp_rec[0]->count;
					$fail_count = $fail_count + 1;
					$block = '0';
					$block_time = date("Y-m-d H:i:s");

					if($fail_count > 3){
						$block = '1';
						$block_time = date("Y-m-d H:i:s",strtotime("+3 hours"));
					}

					$otp_data = array(
						"count" => $fail_count,
						"is_blocked" => $block,
						"block_till" => $block_time,
						"modifiedDate" => date("Y-m-d H:i:s")
					);
  
					$update = $this->Mdl_member->update("login_otp", "id", $otp_rec[0]->id, $otp_data);

					if($block == '1'){
						echo json_encode(array("status"=>"blocked")); exit;
					}else{
						echo json_encode(array("otp"=>"OTP does not match. Try again.")); exit;
					}
				}
				//else if($otp_rec[0]->otp == $content['otp']){
				//else if(md5($otp_rec[0]->otp) == $content['otp']){
				else if(hash('sha256',$otp_rec[0]->otp) == $content['otp']){
				    
					 $result = $this->memberLogin($content['username'], $content['userpassword'],$content['mobile']);

					if($result == 1){
						echo json_encode(array("status"=>"invalid")); exit;
					}else{
						$directory = json_decode($result, true);
						if(!$directory){
							echo json_encode(array("status"=>"invalid_member")); exit;
						}
					}

					$login_rec = 'SELECT * FROM login WHERE username = "'.$content['username'].'" ORDER BY createdDate desc LIMIT 1';
					$record = $this->Mdl_member->customQuery($login_rec);
			
					if($record == "No Data"){
						$login_data = array(
							'username' => $content['username'],
							'mobile' => $content['mobile'],
							'last_login' => date("Y-m-d H:i:s"),
							"createdDate" => date("Y-m-d H:i:s"),
							"modifiedDate" => date("Y-m-d H:i:s")
						);
						
						$insert = $this->Mdl_member->insert('login',$login_data);
					}else{
						$login_data = array(
							'mobile' => $content['mobile'],
							'last_login' => date("Y-m-d H:i:s"),
							"modifiedDate" => date("Y-m-d H:i:s")
						);
						
						$update = $this->Mdl_member->update("login", "id", $record[0]->id, $login_data);
					}		
					
					if($this->session->userdata('referrer_url')){
						$redirect_url = $this->session->userdata('referrer_url');
						$this->session->unset_userdata('referrer_url');
					}else{
						$redirect_url = base_url();
					}
			        
			        
			    $datasessionadd = array(
                  'username'=> $content['username'],
                  'userip'=> $this->input->ip_address(),
                  'loginDateTime'=> date('Y-m-d H:i:s'),
                  'loginStatus'=> 1,
                  'logoutDateTime'=> '',
                  'action'=> 'Login',
                  'modulename'=> 'User Login',
                  'usertype'=> '0',
                  'EventDateTime'=> date('Y-m-d H:i:s')
                );
                
                $insert = $this->Mdl_member->insert("admin_login_activity", $datasessionadd);
                
                 $login_rec = 'SELECT logID FROM admin_login_activity where username = "'.$content['username'].'" ORDER BY logID desc LIMIT 1';
			$record = $this->Mdl_member->customQuery($login_rec);
                $logid = $record[0]->logID;
                session_regenerate_id(true);
					$sessionData = array(
						'username'=> $content['username'],
						'password'=> $content['userpassword'],
						'logID'=>$logid,
                        'type'=>'user'
					);
					$this->session->set_userdata('user', $sessionData);
			
					echo json_encode(array("status"=>"success","url"=>$redirect_url)); exit;			
				}
      }
    }
	}


	/*
	**	Logout Action
	*/
	function logout(){
	$admin = $this->session->userdata('user');
    $logid = $admin['logID'];

    $logout_data = array(
      'loginStatus'=> 0,
      'logoutDateTime'=> date('Y-m-d H:i:s')
    );

    $update_admin_logout = $this->Mdl_member->update("admin_login_activity", "logID", $logid, $logout_data);
    
		$this->session->unset_userdata('user');
		redirect('member/login','refresh');
	}

	/**********************************************************************/
  /*                        MEMBER DIRECTORY                            */
  /**********************************************************************/

	/*
	**	MEMBERS DIRECTORY PAGE
	*/
	function directoryOld($page = ""){
		$limit_per_page = 30;

    $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
    $start_index = ($page - 1) * $limit_per_page;

		// $result = $this->getDirectoryData();
		$post_data = $this->input->post();

		if(empty($post_data)){
			$product = '';
			$name = '';		
			$city = '';		
			$region ='';
			$sort = '';	
		}else{
			$product = $post_data['product'];
			$name = $post_data['cname'];
			$city = $post_data['city'];
			$region =$post_data['region'];
			$sort = $post_data['sort'];
		}

		$result = $this->searchDirectory($product,$name,$city,$region,$sort);

    if($result == 1){
      $total_records = 0;
    }else{
			$directory = json_decode($result, true);
      $total_records = sizeof($directory);
		}
 
    if($total_records > 0){
			$list = array();
			$loop_limit = $start_index + $limit_per_page;
			if($loop_limit > $total_records){
				$loop_limit = $total_records;
			}

			for($i=$start_index; $i < $loop_limit; $i++){
				$list[] = $directory[$i];
			}
			
			$config['base_url'] = base_url().'member/directory';
      $config['total_rows'] = $total_records;
      $config['per_page'] = $limit_per_page;
      $config['use_page_numbers'] = TRUE;

      $config['cur_tag_open'] = '<a class="active">';
      $config['cur_tag_close'] = '</a>';

      $this->pagination->initialize($config);
       
      $links= $this->pagination->create_links();
    }else{
      $list = "No Data";
      $links = '';
		}

    $template = 'home';
    $data['seo'] = $this->Mdl_member->getByValue("seo","page","home");
    $data['country'] = $this->Mdl_member->getAllRecords("country");
    $data['total'] = $total_records;
    $data['directory'] = $list;
    $data['links'] = $links;
    $data['viewFile'] = 'member/directory';
    $data['module'] = "member";

    return view('template/'.$template, $data); 
	}

	/*
	**	MEMBERS DIRECTORY PAGE
	*/
	function directory(){
		// if(!Modules::run('security/isMember')){
		//   redirect('member/login','refresh');
		// }
			
		$template = 'home';
    $data['seo'] = $this->Mdl_member->getByValue("seo","page","home");
    $data['country'] = $this->Mdl_member->getAllRecords("country");
    $data['viewFile'] = 'member/directory';
    $data['scriptFile'] = 'directory';
    $data['module'] = "member";

    return view('template/'.$template, $data); 
	}

/*
	**	GET MEMBERS DIRECTORY DATA
	*/
	function getDirectories(){
		if(!Modules::run('security/isMember')){
		  $userLogin = false;
		}else{
			$userLogin = true;
		}

		$post_data = $this->input->post();

		$product = $post_data['product'];
		$name = $post_data['cname'];
		$city = $post_data['city'];
		$region =$post_data['region'];
		$sort = $post_data['sort'];
		$page = $post_data['page'];
		$record_per_page = 30;
		$start = ($page - 1) * $record_per_page;
		
		// Get Data from API
		$result = $this->searchDirectory($product,$name,$city,$region,$sort);

		$responnse_html = '';

    if($result == 1){
      echo json_encode(array("status"=>"fail")); exit;
    }else{
			$directory = json_decode($result, true);
      $total_records = sizeof($directory);
		}

    if($total_records > 0){
			$list = array();

			$loop_limit = $start + $record_per_page;
			if($loop_limit > $total_records){
				$loop_limit = $total_records;
			}

			// Final Data
			for($i=$start; $i < $loop_limit; $i++){
				$address = '';
				$address .= $directory[$i]['Add1'];

				if($directory[$i]['Add2'] !== ''){	
					$address .= ', '.$directory[$i]['Add2'];
				}

				if($directory[$i]['Add3'] !== ''){	
					$address .= ', '.$directory[$i]['Add3'];
				}

				if($userLogin){
					$responnse_html .= '<div class="col-md-6 mb-4"><div class="border rounded p-3"><h5 class="redColor mb-3">'.ucwords(strtolower($directory[$i]['MemberName'])).'</h5><table class="memberTable"><tr><td>Contact Person	</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['ContactPerson'].'</td></tr><tr><td>Address	</td><td class="semiColon">:</td><td class="boldFont">'.$address.'</td></tr><tr><td>City</td><td class="semiColon">:</td><td class="boldFont">'.ucfirst(strtolower($directory[$i]['CityName'])).'</td></tr><tr><td>Pincode</td><td class="semiColon">:</td><td class="boldFont">'.ucfirst(strtolower($directory[$i]['Pin'])).'</td></tr><tr><td>Phone No</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['TelNo'].'</td></tr><tr><td>Fax No</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['FaxNo'].'</td></tr><tr><td>Email</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['Email'].'</td></tr><tr><td>Website</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['Website'].'</td></tr><tr><td>Panel</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['panel_name'].'</td></tr><tr><td>Category</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['category_name'].'</td></tr></table><div class="redColor mb-3 d-flex justify-content-between align-items-center"><a class="btn p-1 redGradientBg whiteColor" href="javascript:;" id="rec_'.$i.'" onclick="showData(this.id)" data-name="'.ucwords(strtolower($directory[$i]['MemberName'])).'" data-email="'.ucwords(strtolower($directory[$i]['Email'])).'" data-src="#memberEnquiryLogin" data-fancybox="">Contact US</a></div></div></div>';
				}else{
					$responnse_html .= '<div class="col-md-6 mb-4"><div class="border rounded p-3"><h5 class="redColor mb-3">'.ucwords(strtolower($directory[$i]['MemberName'])).'</h5><table class="memberTable"><tr><td>Contact Person	</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['ContactPerson'].'</td></tr><tr><td>Address	</td><td class="semiColon">:</td><td class="boldFont">'.$address.'</td></tr><tr><td>City</td><td class="semiColon">:</td><td class="boldFont">'.ucfirst(strtolower($directory[$i]['CityName'])).'</td></tr><tr><td>Pincode</td><td class="semiColon">:</td><td class="boldFont">'.ucfirst(strtolower($directory[$i]['Pin'])).'</td></tr><tr><td>Phone No</td><td class="semiColon">:</td><td class="boldFont">*</td></tr><tr><td>Fax No</td><td class="semiColon">:</td><td class="boldFont">*</td></tr><tr><td>Email</td><td class="semiColon">:</td><td class="boldFont">*</td></tr><tr><td>Website</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['Website'].'</td></tr><tr><td>Panel</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['panel_name'].'</td></tr><tr><td>Category</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['category_name'].'</td></tr></table><div class="redColor mb-3 d-flex justify-content-between align-items-center"><a href="'.base_url().'member/login" class="d-flex align-items-center"> * Please login to view more details </a> <a class="btn p-1 redGradientBg whiteColor" href="javascript:;" id="rec_'.$i.'" onclick="showData(this.id)" data-name="'.ucwords(strtolower($directory[$i]['MemberName'])).'" data-email="'.ucwords(strtolower($directory[$i]['Email'])).'" data-src="#memberEnquiry" data-fancybox="">Contact US</a></div></div></div>';
				}
			}

			// Pagination
			$pagination_link = '';
			$start_page = $page; 
			$last_page = round($total_records / $record_per_page);
			
			if($page <= $last_page){
				// FIRST PAGE LINK
				if($start_page > '3'){
					$pagination_link .= '<a href="javascript:;" id="1" onclick="paginate(this.id,event)"> FIRST PAGE</a>';
				}

				// 	PREV PAGE LINK
				if($start_page > '1'){
					$pagination_link .= '<a href="javascript:;" id="prev" onclick="paginate(this.id,event)"> PREVIOUS </a>';
				}

				if($start_page < 4){
					$start_link = 1;
					$end_link = 5;
					for($i = $start_link; $i <= $end_link; $i++){
						if($i == $start_page){
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="paginate(this.id,event)" class="active activetxt">'.$i.'</a>';
						}else{
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="paginate(this.id,event)">'.$i.'</a>';
						}
					}
				}else if($start_page > $last_page-3){
					$start_link = $last_page - 5;
					$end_link = $last_page;
					for($i = $start_link; $i <= $end_link; $i++){
						if($i == $start_page){
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="paginate(this.id,event)" class="active activetxt">'.$i.'</a>';
						}else{
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="paginate(this.id,event)">'.$i.'</a>';
						}
					}
				}else{
					$start_link = $start_page - 2;
					$end_link = $start_page + 2;
					for($i = $start_link; $i <= $end_link; $i++){
						if($i == $start_page){
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="paginate(this.id,event)" class="active activetxt">'.$i.'</a>';
						}else{
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="paginate(this.id,event)">'.$i.'</a>';
						}
					}
				}

				// 	NEXT PAGE LINK
				if($start_page < $last_page){
					$pagination_link .= '<a href="javascript:;" id="next" onclick="paginate(this.id,event)"> NEXT </a>';
				}
				
				// LAST PAGE LINK
				if($start_page < $last_page-2){
					$pagination_link .= '<a href="javascript:;" id="'.$last_page.'" onclick="paginate(this.id,event)"> LAST PAGE</a>';
				}
			}
			
    }else{
      $responnse_html = '';
      $pagination_link = '';
		}

		echo json_encode(array("status"=>"success","data"=>$responnse_html,"pagination"=>$pagination_link,"total"=>$total_records)); exit;
		// echo json_encode(array("result"=>"success","pagination"=>$pagination_link)); exit;
	}

	/*
	**	GET MEMBERS DIRECTORY DATA
	*/
	function getDirectorySearchData(){
		if(!Modules::run('security/isMember')){
		  $userLogin = false;
		}else{
			$userLogin = true;
		}

		$post_data = $this->input->post();

		$product = $post_data['product'];
		$name = $post_data['cname'];
		$city = $post_data['city'];
		$region =$post_data['region'];
		$sort = $post_data['sort'];
		$page = $post_data['page'];
		$record_per_page = 30;
		$start = ($page - 1) * $record_per_page;
		
		// Get Data from API
		$result = $this->searchDirectory($product,$name,$city,$region,$sort);

		$responnse_html = '';

    if($result == 1){
      echo json_encode(array("status"=>"fail")); exit;
    }else{
			$directory = json_decode($result, true);
      $total_records = sizeof($directory);
		}
 
    if($total_records > 0){
			$list = array();

			$loop_limit = $start + $record_per_page;
			if($loop_limit > $total_records){
				$loop_limit = $total_records;
			}

			// Final Data
			for($i=$start; $i < $loop_limit; $i++){
				$address = '';
				$address .= $directory[$i]['Add1'];

				if($directory[$i]['Add2'] !== ''){	
					$address .= ', '.$directory[$i]['Add2'];
				}

				if($directory[$i]['Add3'] !== ''){	
					$address .= ', '.$directory[$i]['Add3'];
				}

				if($userLogin){
					$responnse_html .= '<div class="col-md-6 mb-4"><div class="border rounded p-3"><h5 class="redColor mb-3">'.ucwords(strtolower($directory[$i]['MemberName'])).'</h5><table class="memberTable"><tr><td>Contact Person	</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['ContactPerson'].'</td></tr><tr><td>Address	</td><td class="semiColon">:</td><td class="boldFont">'.$address.'</td></tr><tr><td>City</td><td class="semiColon">:</td><td class="boldFont">'.ucfirst(strtolower($directory[$i]['CityName'])).'</td></tr><tr><td>Pincode</td><td class="semiColon">:</td><td class="boldFont">'.ucfirst(strtolower($directory[$i]['Pin'])).'</td></tr><tr><td>Phone No</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['TelNo'].'</td></tr><tr><td>Fax No</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['FaxNo'].'</td></tr><tr><td>Email</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['Email'].'</td></tr><tr><td>Website</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['Website'].'</td></tr><tr><td>Panel</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['panel_name'].'</td></tr><tr><td>Category</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['category_name'].'</td></tr></table><div class="redColor mb-3 d-flex justify-content-between align-items-center"><a class="btn p-1 redGradientBg whiteColor" href="javascript:;" id="rec_'.$i.'" onclick="showData(this.id)" data-name="'.ucwords(strtolower($directory[$i]['MemberName'])).'" data-email="'.ucwords(strtolower($directory[$i]['Email'])).'" data-src="#memberEnquiryLogin" data-fancybox="">Contact US</a></div></div></div>';
				}else{
					$responnse_html .= '<div class="col-md-6 mb-4"><div class="border rounded p-3"><h5 class="redColor mb-3">'.ucwords(strtolower($directory[$i]['MemberName'])).'</h5><table class="memberTable"><tr><td>Contact Person	</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['ContactPerson'].'</td></tr><tr><td>Address	</td><td class="semiColon">:</td><td class="boldFont">'.$address.'</td></tr><tr><td>City</td><td class="semiColon">:</td><td class="boldFont">'.ucfirst(strtolower($directory[$i]['CityName'])).'</td></tr><tr><td>Pincode</td><td class="semiColon">:</td><td class="boldFont">'.ucfirst(strtolower($directory[$i]['Pin'])).'</td></tr><tr><td>Phone No</td><td class="semiColon">:</td><td class="boldFont">*</td></tr><tr><td>Fax No</td><td class="semiColon">:</td><td class="boldFont">*</td></tr><tr><td>Email</td><td class="semiColon">:</td><td class="boldFont">*</td></tr><tr><td>Website</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['Website'].'</td></tr><tr><td>Panel</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['panel_name'].'</td></tr><tr><td>Category</td><td class="semiColon">:</td><td class="boldFont">'.$directory[$i]['category_name'].'</td></tr></table><div class="redColor mb-3 d-flex justify-content-between align-items-center"><a href="'.base_url().'member/login" class="d-flex align-items-center"> * Please login to view more details </a> <a class="btn p-1 redGradientBg whiteColor" href="javascript:;" id="rec_'.$i.'" onclick="showData(this.id)" data-name="'.ucwords(strtolower($directory[$i]['MemberName'])).'" data-email="'.ucwords(strtolower($directory[$i]['Email'])).'" data-src="#memberEnquiry" data-fancybox="">Contact US</a></div></div></div>';
				}
			}

			// Pagination
			$pagination_link = '';
			$start_page = $page; 
			$last_page = round($total_records / $record_per_page);
			
			if($page <= $last_page){
				// FIRST PAGE LINK
				if($start_page > '3'){
					$pagination_link .= '<a href="javascript:;" id="1" onclick="searchPaginate(this.id,event)"> FIRST PAGE</a>';
				}

				// 	PREV PAGE LINK
				if($start_page > '1'){
					$pagination_link .= '<a href="javascript:;" id="prev" onclick="searchPaginate(this.id,event)"> PREVIOUS </a>';
				}

				if($start_page < 4){
					$start_link = 1;
					if($last_page < 5){
						$end_link = $last_page;
					}else{
						$end_link = 5;
					}
					
					for($i = $start_link; $i <= $end_link; $i++){
						if($i == $start_page){
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="searchPaginate(this.id,event)" class="active activetxt">'.$i.'</a>';
						}else{
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="searchPaginate(this.id,event)">'.$i.'</a>';
						}
					}
				}else if($start_page > $last_page-3){
					$start_link = $last_page - 5;
					if($start_link < 1){
						$start_link = 1;
					}
					$end_link = $last_page;
					for($i = $start_link; $i <= $end_link; $i++){
						if($i == $start_page){
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="searchPaginate(this.id,event)" class="active activetxt">'.$i.'</a>';
						}else{
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="searchPaginate(this.id,event)">'.$i.'</a>';
						}
					}
				}else{
					$start_link = $start_page - 2;
					$end_link = $start_page + 2;
					for($i = $start_link; $i <= $end_link; $i++){
						if($i == $start_page){
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="searchPaginate(this.id,event)" class="active activetxt">'.$i.'</a>';
						}else{
							$pagination_link .= '<a href="javascript:;" id="'.$i.'" onclick="searchPaginate(this.id,event)">'.$i.'</a>';
						}
					}
				}

				// 	NEXT PAGE LINK
				if($start_page < $last_page){
					$pagination_link .= '<a href="javascript:;" id="next" onclick="searchPaginate(this.id,event)"> NEXT </a>';
				}
				
				// LAST PAGE LINK
				if($start_page < $last_page-2){
					$pagination_link .= '<a href="javascript:;" id="'.$last_page.'" onclick="searchPaginate(this.id,event)"> LAST PAGE</a>';
				}
			}
			
    }else{
      $responnse_html = '';
      $pagination_link = '';
		}

		echo json_encode(array("status"=>"success","data"=>$responnse_html,"pagination"=>$pagination_link,"total"=>$total_records)); exit;
		// echo json_encode(array("result"=>"success","pagination"=>$pagination_link)); exit;
	}

	/*
  **  OTP ACTION 
  */
  function generateEnquiryOtp(){
    $content = $this->input->post();

    $this->form_validation->set_rules("enquiry_country","Country","trim|required|xss_clean",
    array(
      'required' => "Select country"
    ));

    if($content['enquiry_country'] == "91"){
      $this->form_validation->set_rules("enquiry_mobile","Mobile Number","trim|required|xss_clean|exact_length[10]|integer",
      array(
        'required' => "Enter mobile",
        'integer' => "Invalid mobile",
        'exact_length' => "Invalid mobile"
      ));
    }else{
      $this->form_validation->set_rules("enquiry_mobile","Mobile Number","trim|required|xss_clean|min_length[7]|max_length[15]|integer",
      array(
        'required' => "Enter mobile",
        'integer' => "Invalid mobile",
        'min_length' => "Invalid mobile",
        'max_length' => "Invalid mobile"
      ));
    }

    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors); exit;
    }else{
      $query = 'SELECT * FROM enquiry_otp WHERE mobile = "'.$content['enquiry_mobile'].'" ORDER BY createdDate desc LIMIT 1';
      $otp_rec = $this->Mdl_member->customQuery($query);

      $new = false;

      if($otp_rec == "No Data"){
        $new = true;  
      }else if($otp_rec[0]->is_blocked == '1'){
        if(strtotime("now") < strtotime($otp_rec[0]->block_till)){
          echo json_encode(array("status"=>"blocked")); exit;
        }else{
          $otp_data = array(
            "count" => 0,
            "is_blocked" => '0',
            "block_till" => date("Y-m-d H:i:s"),
            "modifiedDate" => date("Y-m-d H:i:s")
          );

          $update = $this->Mdl_member->update("enquiry_otp", "id", $otp_rec[0]->id, $otp_data);
        } 
      }

      $otp = rand(1000,9999);

      $response = $this->sendSMS($content['enquiry_country'],$content['enquiry_mobile'],$otp);

      if($response == '1'){
        echo json_encode(array("status"=>"error","msg"=>"Something went wrong. Please try again.")); exit;
      }else{
        $result = json_decode($response, true);

        if($result['type'] == "error"){
          echo json_encode(array("status"=>"error","msg"=>$result['message'])); exit;
        }else if($result['type'] == "success"){
          
          if($new){
            $otp_data = array(
              'mobile' => $content['enquiry_mobile'],
              'otp' => $otp,
              "count" => 0,
              "is_blocked" => '0',
              "block_till" => date("Y-m-d H:i:s"),
              "createdDate" => date("Y-m-d H:i:s"),
              "modifiedDate" => date("Y-m-d H:i:s")
            );

            $insert = $this->Mdl_member->insert('enquiry_otp',$otp_data);
          }else{
            $otp_data = array(
              'otp' => $otp,
              "modifiedDate" => date("Y-m-d H:i:s")
            );

            $update = $this->Mdl_member->update("enquiry_otp","id", $otp_rec[0]->id, $otp_data);
          }
          echo json_encode(array("status"=>"success")); exit;
        }
      }
    }
	}

	/*
  **  RESEND OTP ACTION 
  */
  function resendEnquiryOtp(){
    $content = $this->input->post();

    $this->form_validation->set_rules("enquiry_country","Country","trim|required|xss_clean",
    array(
      'required' => "Select country"
    ));

    if($content['enquiry_country'] == "91"){

      $this->form_validation->set_rules("enquiry_mobile","Mobile Number","trim|required|xss_clean|exact_length[10]|integer",
      array(
        'required' => "Enter mobile",
        'integer' => "Invalid mobile",
        'exact_length' => "Invalid mobile"
			));
			
    }else{

      $this->form_validation->set_rules("enquiry_mobile","Mobile Number","trim|required|xss_clean|min_length[7]|max_length[15]|integer",
      array(
        'required' => "Enter mobile",
        'integer' => "Invalid mobile",
        'min_length' => "Invalid mobile",
        'max_length' => "Invalid mobile"
      ));
    }

    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors); exit;
    }else{
      $query = 'SELECT * FROM enquiry_otp WHERE mobile = "'.$content['enquiry_mobile'].'" ORDER BY createdDate desc LIMIT 1';
      $otp_rec = $this->Mdl_member->customQuery($query);

      $new = false;

      if($otp_rec == "No Data"){
        $new = true;  
      }else if($otp_rec[0]->is_blocked == '1'){
        if(strtotime("now") < strtotime($otp_rec[0]->block_till)){
          echo json_encode(array("status"=>"blocked")); exit;
        }else{
          $otp_data = array(
            "count" => 0,
            "is_blocked" => '0',
            "block_till" => date("Y-m-d H:i:s"),
            "modifiedDate" => date("Y-m-d H:i:s")
          );

          $update = $this->Mdl_member->update("enquiry_otp", "id", $otp_rec[0]->id, $otp_data);
        } 
      }

      $otp = rand(1000,9999);

      $response = $this->sendSMS($content['enquiry_country'],$content['enquiry_mobile'],$otp);

      if($response == '1'){
        echo json_encode(array("status"=>"error","msg"=>"Something went wrong. Please try again.")); exit;
      }else{
        $result = json_decode($response, true);

        if($result['type'] == "error"){
          echo json_encode(array("status"=>"error","msg"=>$result['message'])); exit;
        }else if($result['type'] == "success"){
          
          if($new){
            $otp_data = array(
              'mobile' => $content['enquiry_mobile'],
              'otp' => $otp,
              "count" => 0,
              "is_blocked" => '0',
              "block_till" => date("Y-m-d H:i:s"),
              "createdDate" => date("Y-m-d H:i:s"),
              "modifiedDate" => date("Y-m-d H:i:s")
            );

            $insert = $this->Mdl_member->insert('enquiry_otp',$otp_data);
          }else{
            $otp_data = array(
              'otp' => $otp,
              "modifiedDate" => date("Y-m-d H:i:s")
            );

            $update = $this->Mdl_member->update("enquiry_otp","id", $otp_rec[0]->id, $otp_data);
          }
          echo json_encode(array("status"=>"success")); exit;
        }
      }
    }
	}

	/*
  **  ENQUIRY ACTION 
  */
  function enquiryAction(){
    $content = $this->input->post();

		$this->form_validation->set_rules("enquiry_name","Name","trim|required|xss_clean",
		array(
			'required' => "Name is required",
		));
      
		$this->form_validation->set_rules("enquiry_email","Email","trim|required|xss_clean|valid_email",
		array(
			'required' => "Email is required.",
			'valid_email' => "Email is invalid."
		));

		$this->form_validation->set_rules("enquiry_country","country","trim|xss_clean|required",
		array(
			'required' => "Select Country"
		));

		if($content['enquiry_country'] == "91"){
			$this->form_validation->set_rules("enquiry_mobile","Mobile Number","trim|required|xss_clean|exact_length[10]|integer",
			array(
				'required' => "Mobile is required",
				'integer' => "Invalid mobile",
				'exact_length' => "Invalid mobile"
			));
		}else{
			$this->form_validation->set_rules("enquiry_mobile","Mobile Number","trim|required|xss_clean|min_length[7]|max_length[15]|integer",
			array(
				'required' => "Mobile is required",
				'integer' => "Invalid mobile",
				'min_length' => "Invalid mobile",
				'max_length' => "Invalid mobile"
			));
		}

		if($content['otp_sent'] == "yes"){
			$this->form_validation->set_rules("enquiry_otp","OTP","trim|required|xss_clean|exact_length[4]|integer",
			array(
				'required' => "Enter otp",
				'integer' => "Invalid otp",
				'exact_length' => "Invalid otp"
			));
		}
		
		$this->form_validation->set_rules("enquiry_message","Message","trim|xss_clean");

		if($this->form_validation->run() == FALSE){
			$errors = $this->form_validation->error_array();
			echo json_encode($errors); exit;
		}else{
			if($content['otp_sent'] == "no"){
				echo json_encode(array("status"=>"verify_mobile")); exit;
			}else{
				$query = 'SELECT * FROM enquiry_otp WHERE mobile = "'.$content['enquiry_mobile'].'" ORDER BY createdDate desc LIMIT 1';
				$otp_rec = $this->Mdl_member->customQuery($query);

				if($otp_rec == "No Data"){
					echo json_encode(array("status"=>"verify_mobile")); exit;
				}else if($otp_rec[0]->is_blocked == "1"){
					echo json_encode(array("status"=>"blocked")); exit;
				}else if($otp_rec[0]->otp !== $content['enquiry_otp']){
					$fail_count = $otp_rec[0]->count;
					$fail_count = $fail_count + 1;
					$block = '0';
					$block_time = date("Y-m-d H:i:s");

					if($fail_count > 3){
						$block = '1';
						$block_time = date("Y-m-d H:i:s",strtotime("+3 hours"));
					}

					$otp_data = array(
						"count" => $fail_count,
						"is_blocked" => $block,
						"block_till" => $block_time,
						"modifiedDate" => date("Y-m-d H:i:s")
					);

					$update = $this->Mdl_member->update("enquiry_otp", "id", $otp_rec[0]->id, $otp_data);

					if($block == '1'){
						echo json_encode(array("status"=>"blocked")); exit;
					}else{
						echo json_encode(array("enquiry_otp"=>"OTP does not match.")); exit;
					}
				}else if($otp_rec[0]->otp == $content['enquiry_otp']){
					$countryRec = $this->Mdl_member->getByValue("country", "phonecode", $content['enquiry_country']);

					$otp_data = array(
						"count" => 0,
						"is_blocked" => 0,
						"modifiedDate" => date("Y-m-d H:i:s")
					);

					$update = $this->Mdl_member->update("enquiry_otp", "id", $otp_rec[0]->id, $otp_data);

					if($countryRec !== "No Data"){
						$country = $countryRec[0]->countryName;
					}else{
						$country = "No Record";
					}

					$enquiry_data = array(
						'member_name' => $content['member_name'],
						'member_email' => $content['member_email'],
						'name' => $content['enquiry_name'],
						'email' => $content['enquiry_email'],
						'country' => $country,
						"mobile" => $content['enquiry_mobile'],
						"message" => $content['enquiry_message'],
						"createdDate" => date("Y-m-d H:i:s")
					);

					$insert = $this->Mdl_member->insert('member_enquiry',$enquiry_data);
	
					$mail_data_plex = array(
						"viewFile"=>'member/enquiry',
						"to" => $content['member_email'],
						"cc" => "office@plexconcil.org",
						"bcc" =>"",
						"subject"=>'ENQUIRY MESSAGE - PLEXCONCIL',
						'name' => strip_tags($content['enquiry_name']),
						'email' => strip_tags($content['enquiry_email']),
						'mobile' => strip_tags($content['enquiry_mobile']),
						'country' =>  $country,
						'message' => strip_tags($content['enquiry_message'])
					);
					
					$status_ack_mail = Modules::run('email/mailer', $mail_data_plex);

					echo json_encode(array("status"=>"success")); exit;
				}
			}
		}
	}
	
	/*
  **  ENQUIRY ACTION 
  */
  function enquiryLoginAction(){
    $content = $this->input->post();

		$this->form_validation->set_rules("enquiry_name","Name","trim|required|xss_clean",
		array(
			'required' => "Name is required",
		));
      
		$this->form_validation->set_rules("enquiry_email","Email","trim|required|xss_clean|valid_email",
		array(
			'required' => "Email is required.",
			'valid_email' => "Email is invalid."
		));

		$this->form_validation->set_rules("enquiry_country","country","trim|xss_clean|required",
		array(
			'required' => "Select Country"
		));

		if($content['enquiry_country'] == "91"){
			$this->form_validation->set_rules("enquiry_mobile","Mobile Number","trim|required|xss_clean|exact_length[10]|integer",
			array(
				'required' => "Mobile is required",
				'integer' => "Invalid mobile",
				'exact_length' => "Invalid mobile"
			));
		}else{
			$this->form_validation->set_rules("enquiry_mobile","Mobile Number","trim|required|xss_clean|min_length[7]|max_length[15]|integer",
			array(
				'required' => "Mobile is required",
				'integer' => "Invalid mobile",
				'min_length' => "Invalid mobile",
				'max_length' => "Invalid mobile"
			));
		}
		
		$this->form_validation->set_rules("enquiry_message","Message","trim|xss_clean");

		if($this->form_validation->run() == FALSE){
			$errors = $this->form_validation->error_array();
			echo json_encode($errors); exit;
		}else{
			$enquiry_data = array(
				'member_name' => $content['member_name'],
				'member_email' => $content['member_email'],
				'name' => $content['enquiry_name'],
				'email' => $content['enquiry_email'],
				'country' => $content['enquiry_country'],
				"mobile" => $content['enquiry_mobile'],
				"message" => $content['enquiry_message'],
				"createdDate" => date("Y-m-d H:i:s")
			);

			$insert = $this->Mdl_member->insert('member_enquiry',$enquiry_data);
	
			$mail_data_plex = array(
				"viewFile"=>'member/enquiry',
				"to"=>$content['member_email'],
				"cc" =>"office@plexconcil.org",
				"bcc" =>"",
				"subject"=>'ENQUIRY MESSAGE - PLEXCONCIL',
				'name' => strip_tags($content['enquiry_name']),
				'email' => strip_tags($content['enquiry_email']),
				'mobile' => strip_tags($content['enquiry_mobile']),
				'country' => $content['enquiry_country'],
				'message' => strip_tags($content['enquiry_message'])
			);
			
			$status_ack_mail = Modules::run('email/mailer', $mail_data_plex);

			echo json_encode(array("status"=>"success")); exit;
		}
  }

	/**********************************************************************/
  /*                           		API				                            */
  /**********************************************************************/
	function searchDirectory($product,$name,$city,$region,$sort){
		$curl = curl_init();

		curl_setopt_array($curl, array(
  CURLOPT_URL => "https://membership.plasticsepc.org/admin/active_member_details.php",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 100,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "POST",
  CURLOPT_POSTFIELDS => "txtproduct=$product&txtcompanyname=$name&txtcity=$city&txtregion=$region&txtsortby=$sort&apikey=plex%40rep%40api",
  CURLOPT_HTTPHEADER => array(
    "cache-control: no-cache",
    "content-type: application/x-www-form-urlencoded",
	"postman-token: c988faf7-00bd-c433-aa89-dca52a85dc64"
  ),
));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if($err) {
			return '1';
		} else {
			return $response;
		}
	}		

  function sendSMS($isd='91',$mobile,$otp){
   // $msg = 'Your OTP for mobile verification is '.$otp;
   $msg =   'Your OTP for mobile verification on Plexconcil website is '.$otp;
   $mno = $isd.$mobile;
    $curl = curl_init();
 /*
    curl_setopt_array($curl, array(
      CURLOPT_URL => "http://api.msg91.com/api/v2/sendsms?country=$isd",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 100,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_POSTFIELDS => "{ \"sender\": \"PLEXCL\",\"template_id\":\"6242d2348e4ca73e1e22db61\", \"route\": \"4\",\"country\": \"$isd\", \"sms\": [ { \"message\": \"$msg\", \"to\": [ \"$mobile\" ] } ] }",
      CURLOPT_SSL_VERIFYHOST => 0,
      CURLOPT_SSL_VERIFYPEER => 0,
      CURLOPT_HTTPHEADER => array(
        "authkey: 275881AvZ3IIFhKSE5cd4038f",
        "content-type: application/json"
      ),
    ));

curl_setopt_array($curl, [
  CURLOPT_URL => "https://api.msg91.com/api/v5/otp?template_id=6242d2348e4ca73e1e22db61&mobile=$mno&authkey=275881AvZ3IIFhKSE5cd4038f&OTP=$otp",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  CURLOPT_POSTFIELDS => "{\"Value1\":\"Param1\",\"Value2\":\"Param2\",\"Value3\":\"Param3\",\"Value4\":\"Param4\"}",
  CURLOPT_HTTPHEADER => [
    "Content-Type: application/json"
  ],
]);

curl_setopt_array($curl, [
  CURLOPT_URL => "https://api.msg91.com/api/sendotp.php?sender=PLEXCL&mobile=$mno&message=$msg&authkey=275881AvZ3IIFhKSE5cd4038f&template_id=6242d2348e4ca73e1e22db61&otp=$otp",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  CURLOPT_POSTFIELDS => "{\"Value1\":\"Param1\",\"Value2\":\"Param2\",\"Value3\":\"Param3\",\"Value4\":\"Param4\"}",
  CURLOPT_HTTPHEADER => [
    "Content-Type: application/json"
  ],
]);
*/
 curl_setopt_array($curl, array(
      CURLOPT_URL => "http://api.msg91.com/api/v2/sendsms?country=$isd",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 100,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "POST",
      CURLOPT_POSTFIELDS => "{ \"sender\": \"PLEXCL\",\"DLT_TE_ID\":\"1707164802789215251\", \"route\": \"4\",\"country\": \"$isd\",\"authkey\":\"275881AvZ3IIFhKSE5cd4038f\", \"sms\": [ { \"message\": \"$msg\", \"to\": [ \"$mno\" ] } ]}",
      CURLOPT_SSL_VERIFYHOST => 0,
      CURLOPT_SSL_VERIFYPEER => 0,
      CURLOPT_HTTPHEADER => array(
        "authkey: 275881AvZ3IIFhKSE5cd4038f",
        "content-type: application/json"
      ),
    ));
    
    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if($err){
return '1';
    }else{
      return $response;
    }
	}
	
	function memberLogin($username, $password,$mobileno){
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://membership.plasticsepc.org/api/plexconcil_functions_post_new.php",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => "------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"txtusername\"\r\n\r\n$username\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"txtpassword\"\r\n\r\n$password\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"txtmobileno\"\r\n\r\n$mobileno\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW\r\nContent-Disposition: form-data; name=\"apikey\"\r\n\r\nplex@rep@api\r\n------WebKitFormBoundary7MA4YWxkTrZu0gW--",
  		CURLOPT_HTTPHEADER => array(
				"cache-control: no-cache",
				"content-type: multipart/form-data; boundary=----WebKitFormBoundary7MA4YWxkTrZu0gW",
				"postman-token: 9fe83cf5-b11b-a006-fba4-07bd47a0be44"
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if($err){
      return '1';
    }else{
      return $response;
    }
	}

	function testLogin(){
		$result = $this->memberLogin("shrutimca21@gmail.com", "1212457878");

		if($result == 1){
			echo "error";
		}else{
			$directory = json_decode($result, true);
			var_dump($directory);
		}
	}
}
