<?php 
namespace App\Modules\Mous\Controllers;
ini_set("memory_limit","512M");
error_reporting(E_ALL ^ E_NOTICE);



use App\Modules\generic\Models\Mdl_generic;

use App\Modules\Mous\Models\Mdl_mous;

use CodeIgniter\Controller;

class Mous extends Controller
{
   private $db;
 protected  $viewFile;
 protected  $email;
 protected  $captcha; 
 protected  $isLogin;
 
    /**
     * Constructor.
     */
    public function __construct()
    {
        //$db = \Config\Database::connect();
        $this->Mdl_mous = new Mdl_mous();
    }

   function index(){
    $statement = 'SELECT * FROM mous WHERE status = "1" ORDER BY createdDate desc';
    $result = $this->Mdl_mous->customQuery($statement);
    $data['mous'] = $result;
    $data['seo'] = $this->Mdl_mous->getByValue("seo","page","home");
    $data['country'] = $this->Mdl_mous->getAllRecords("country");
    $data['viewFile'] = "mous/mous";
    $data['scriptFile'] = "mous";
    $data['module'] = "mous";
    $data['captcha'] = "";
    $template = 'home';
    return view('template/'.$template, $data);
  }

	/*************************************************************************/
	/* 														ADMIN MODULE															 */
	/*************************************************************************/
	
	/*
	**	REPORT LISTING PAGE
	*/
	function viewall(){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }
    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);

    if(! in_array("27.1",$rights)){
      redirect('admin/dashboard','refresh');
    }

    $template = 'admin';
    $data['scriptFile'] = 'admin-mous_v_1.0';
    $data['viewFile'] = 'mous/list-mous';
    $data['module'] = "mous";
    return view('template/'.$template, $data);
  }
	
	/*
  **  GET LIST OF REPORT
  */
  function getMous(){
    $list = $this->Mdl_mous->get_datatables();
    $data = array();
    $no = $_POST['start']; 
    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');

    #track log
    $admin_array['userid'] = $admin['id'];
    $admin_array['usertype'] = 'admin';
    $admin_array['action_type'] = 'View';
    $admin_array['modulename'] = 'Mous';

    $admin_array['userip'] = $this->input->ip_address();
    $log =  insertTrackLog($admin_array);

    foreach ($list as $val) {
      $row = array();
      $url = base_url().'mous/update/'.$val->id;
      $row[] = '<a class="btn btn-rounded btn-outline-success" href="'.$url.'">UPDATE</a>';
      
      if($admin['isAdmin'] !== '1'){
        $row[] = '<button class="btn btn-block btn-rounded btn-outline-danger" id="'.$val->id.'" onclick="callDeleteFunction(\'mous\',\'id\',this.id,\'table\')">DELETE</button>';
      }else{
        $row[] = '';
      }

      $row[] = $val->name;
      
      $pdf_url = base_url().$val->filepath;
      $row[] = '<a class="btn btn-rounded btn-outline-info" target="_blank" href="'.$pdf_url.'"><i class="fa fa-file-pdf-o" aria-hidden="true"> VIEW </i></a>';

			if($val->status == '1'){
        $status = '<span class="badge badge-success">ACTIVE</span>';
      }else{
        $status = '<span class="badge badge-danger">DEACTIVE</span>';
      }
      $row[] = $status;
      $row[] = strtoupper($val->admin);
      $row[] = date('d-m-Y',strtotime($val->modifiedDate));
      $data[] = $row;
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Mdl_mous->count_all(),
      "recordsFiltered" => $this->Mdl_mous->count_filtered(),
      "data" => $data,
    );

    echo json_encode($output);
	}
	
  /*
  ** ADD NEW REPORT
  */
  function add(){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }
    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);

    if(! in_array("27.2",$rights)){
      redirect('admin/dashboard','refresh');
    }
    
    $data['viewFile'] = "mous/add-mous";
    $data['scriptFile'] = "admin-mous_v_1.0";
    $data['module'] = "mous";
    $template = 'admin';
    return view('template/'.$template, $data);
  }

  /*
  ** ADD REPORT ACTION
  */
  function addMousAction(){
    $content = $this->input->post();

    $this->form_validation->set_rules("name","name","trim|required|xss_clean|max_length[255]",
    array(
      'required' => 'Name is required.','max_length' => 'Name is invalid.'
    ));

    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors);
    }else{
      if(!empty($_FILES['pdf']['name'])){
        $filename = $_FILES['pdf']['name'];
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        $imagename = strtotime('now');
        $img = $this->uploadFile($imagename,"pdf");
        $imgpath = 'public/custom/files/mous/'.$imagename.'.'.$ext;
        if($img !== 1){
          echo json_encode(array("pdf"=>$img)); exit;
        }
      }else{
        echo json_encode(array("pdf"=>"Please upload file")); exit;
      }
      $admin_array['logID'] = $admin['logID'];
      $admin = $this->session->userdata('admin');

      $data = array(
        'name'=> strip_tags($content['name']),
        'filepath'=> strip_tags($imgpath),
        'status'=> '1',
        'admin'=>Modules::run('admin/getAdminName',$admin['id']),
        'createdDate'=>date('Y-m-d H:i:s'),
        'modifiedDate'=>date('Y-m-d H:i:s')
      );

      $insert = $this->Mdl_mous->insert("mous", $data);

      #track log
      $admin_array['userid'] = $admin['id'];
      $admin_array['usertype'] = 'admin';
      $admin_array['action_type'] = 'Insert';
      $admin_array['modulename'] = 'Mous';
      $admin_array['userip'] = $this->input->ip_address();

      $log =  insertTrackLog($admin_array);

      echo json_encode(array("status"=>"success")); exit;
    }
  }
  
  /*
  ** UPDATE REPORT
  */
  function update($id){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }
    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);
    
    if(! in_array("27.3",$rights)){
      redirect('admin/dashboard','refresh');
    }

    $result = $this->Mdl_mous->getByValue("mous","id",$id);
    if($result == "No Data"){
      redirect('errors','refresh');
    }else{
      $data['mous'] = $result;
      $data['viewFile'] = "mous/update-mous";
      $data['scriptFile'] = "admin-mous_v_1.0";
      $data['module'] = "mous";
      $template = 'admin';
      return view('template/'.$template, $data);
    }
  }

  /*
  ** UPDATE REPORT ACTION
  */
  function updateMousAction(){
    $content = $this->input->post(); 

    $this->form_validation->set_rules("name","name","trim|required|xss_clean|max_length[255]",
    array(
      'required' => 'Name is required.','max_length' => 'Name is invalid.'
    ));

    $this->form_validation->set_rules("status","Status","trim|required|xss_clean|max_length[100]",
    array(
      'required' => 'Status is not selected.','max_length' => 'Status is invalid.'
    ));

    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors);
    }else{
      if(!empty($_FILES['pdf']['name'])){
        if(file_exists('./'.$content['pdf_path'])){
          $this->removeImage($content['pdf_path']);
        }
        
        $filename = $_FILES['pdf']['name'];
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        $imagename = strtotime('now');
        $img = $this->uploadFile($imagename,"pdf");
        $imgpath = 'public/custom/files/mous/'.$imagename.'.'.$ext;
        if($img !== 1){
          echo json_encode(array("pdf"=>$img)); exit;
        }
      }else{
        $imgpath = $content['pdf_path'];
      }
      $admin_array['logID'] = $admin['logID'];
      $admin = $this->session->userdata('admin');

      $data = array(
        'name'=> strip_tags($content['name']),
        'filepath'=> strip_tags($imgpath),
        'status'=> strip_tags($content['status']),
        'admin'=>Modules::run('admin/getAdminName',$admin['id']),
        'modifiedDate'=>date('Y-m-d H:i:s')
      );

      $insert = $this->Mdl_mous->update("mous", "id", $content['id'], $data);

      #track log
      $admin_array['userid'] = $admin['id'];
      $admin_array['usertype'] = 'admin';
      $admin_array['action_type'] = 'Update';
      $admin_array['modulename'] = 'Mous';
      $admin_array['userip'] = $this->input->ip_address();


      $log =  insertTrackLog($admin_array);
      
      echo json_encode(array("status"=>"success")); exit;
    }
  }

	/*
  **  File Upload
  */
  function uploadFile($imageName,$key){
    $config['file_name'] = $imageName;
    $config['upload_path'] = './public/custom/files/mous';
    $config['allowed_types'] = "pdf|PDF";
    $config['max_size']  = '10000';
    
    $this->load->library('upload',$config);
    $this->upload->initialize($config);
    if (!$this->upload->do_upload($key)){
      return $this->upload->display_errors();
    }else{
      return 1;
    }
  }

}
