<?php 
namespace App\Modules\Spstbt\Controllers;
ini_set("memory_limit","512M");
error_reporting(E_ALL ^ E_NOTICE);



use App\Modules\generic\Models\Mdl_generic;

use App\Modules\Spstbt\Models\Mdl_spstbt;

use CodeIgniter\Controller;

class Spstbt extends Controller
{
   private $db;
 protected  $viewFile;
 protected  $email;
 protected  $captcha; 
 protected  $isLogin;
 
    /**
     * Constructor.
     */
    public function __construct()
    {
        //$db = \Config\Database::connect();
        $this->Mdl_spstbt = new Mdl_spstbt();
    }

function index(){
    $statement = 'SELECT * FROM spstbt WHERE status = "1" ORDER BY createdDate desc';
    $result = $this->Mdl_spstbt->customQuery($statement);

    $data['spstbt'] = $result;
    $data['country'] = $this->Mdl_spstbt->getAllRecords("country");
    $data['seo'] = $this->Mdl_spstbt->getByValue("seo","page","home");
    
    $data['viewFile'] = "spstbt/spstbt";
    $data['module'] = "spstbt";
    $data['captcha'] = "";
    $template = 'home';
    return view('template/'.$template, $data);
  }

	/*************************************************************************/
	/* 														ADMIN MODULE															 */
	/*************************************************************************/
	
	/*
	**	STATISTICS LISTING PAGE
	*/
	function viewall(){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }

    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);

    if(! in_array("28.1",$rights)){
      redirect('admin/dashboard','refresh');
    }

    $template = 'admin';
    $data['scriptFile'] = 'admin-spstbt_v_1.0';
    $data['viewFile'] = 'spstbt/list-spstbt';
    $data['module'] = "spstbt";
    return view('template/'.$template, $data);
  }
	
	/*
  **  GET LIST OF spstbt
  */
  function getSpstbt(){
    $list = $this->Mdl_spstbt->get_datatables();
    $data = array();
    $no = $_POST['start']; 
    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    
    #track log
    $admin_array['userid'] = $admin['id'];
    $admin_array['usertype'] = 'admin';
    $admin_array['action_type'] = 'View';
    $admin_array['modulename'] = 'spstbt';
    $admin_array['userip'] = $this->input->ip_address();

    $log =  insertTrackLog($admin_array);
    //print_r($list);
    foreach ($list as $val) {
      $row = array();
      $url = base_url().'spstbt/update/'.$val->id;
      $row[] = '<a class="btn btn-rounded btn-outline-success" href="'.$url.'">UPDATE</a>';
      
      if($admin['isAdmin'] !== '1'){
        $row[] = '<button class="btn btn-block btn-rounded btn-outline-danger" id="'.$val->id.'" onclick="callDeleteFunction(\'spstbt\',\'id\',this.id,\'spstbt\')">DELETE</button>';
      }else{
        $row[] = '';
      }

      $row[] = $val->title;
      
      $pdf_url = base_url().$val->filepath;
      $row[] = '<a class="btn btn-rounded btn-outline-info" target="_blank" href="'.$pdf_url.'"><i class="fa fa-file-pdf-o" aria-hidden="true"> VIEW </i></a>';

			if($val->status == '1'){
        $status = '<span class="badge badge-success">ACTIVE</span>';
      }else{
        $status = '<span class="badge badge-danger">DEACTIVE</span>';
      }
      $row[] = $status;
      $row[] = strtoupper($val->admin);
      $row[] = date('d-m-Y',strtotime($val->modifiedDate));
      $data[] = $row;
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Mdl_spstbt->count_all(),
      "recordsFiltered" => $this->Mdl_spstbt->count_filtered(),
      "data" => $data,
    );

    echo json_encode($output);
	}
	
  /*
  ** ADD NEW spstbt
  */
  function add(){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }

    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);

    if(! in_array("28.2",$rights)){
      redirect('admin/dashboard','refresh');
    }
    
    $data['viewFile'] = "spstbt/add-spstbt";
    $data['scriptFile'] = "admin-spstbt_v_1.0";
    $data['module'] = "spstbt";
    $template = 'admin';
    return view('template/'.$template, $data);
  }

  /*
  ** ADD spstbt ACTION
  */
  function addSpstbtAction(){
    $content = $this->input->post();

    $this->form_validation->set_rules("title","Title","trim|required|xss_clean|max_length[100] ",
    array(
      'required' => 'Title is required.',
      'max_length' => 'Title is invalid.'
    ));

    $this->form_validation->set_rules("overview","Overview","trim|xss_clean");

    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors);
    }else{
      if(!empty($_FILES['pdf']['name'])){
        $filename = $_FILES['pdf']['name'];
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        $imagename = strtotime('now');
        $img = $this->uploadFile($imagename,"pdf");
        $imgpath = 'public/custom/files/spstbt/'.$imagename.'.'.$ext;
        if($img !== 1){
          echo json_encode(array("pdf"=>$img)); exit;
        }
      }
      //else{
//        echo json_encode(array("pdf"=>"Please upload file")); exit;
 //     }

      $admin_array['logID'] = $admin['logID'];
      $admin = $this->session->userdata('admin');

      $data = array(
        'title'=> strip_tags($content['title']),
        'overview'=> strip_tags($content['overview']),
        'filepath'=> strip_tags($imgpath),
        'status'=> '1',
        'admin'=>Modules::run('admin/getAdminName',$admin['id']),
        'createdDate'=>date('Y-m-d H:i:s'),
        'modifiedDate'=>date('Y-m-d H:i:s')
      );

      $insert = $this->Mdl_spstbt->insert("spstbt", $data);
$insertId = $this->db->insert_id();
      #track log
      $admin_array['userid'] = $admin['id'];
      $admin_array['usertype'] = 'admin';
      $admin_array['action_type'] = 'Insert';
      $admin_array['modulename'] = 'spstbt';
      $admin_array['event_id'] = $insertId;
      $admin_array['userip'] = $this->input->ip_address();

      $log =  insertTrackLog($admin_array);

      echo json_encode(array("status"=>"success")); exit;
    }
  }
  
  /*
  ** UPDATE spstbt
  */
  function update($id){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }

    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);
    
    if(! in_array("28.3",$rights)){
      redirect('admin/dashboard','refresh');
    }

    $result = $this->Mdl_spstbt->getByValue("spstbt","id",$id);
    if($result == "No Data"){
      redirect('errors','refresh');
    }else{
      $data['spstbt'] = $result;
      $data['viewFile'] = "spstbt/update-spstbt";
      $data['scriptFile'] = "admin-spstbt_v_1.0";
      $data['module'] = "spstbt";
      $template = 'admin';
      return view('template/'.$template, $data);
    }
  }

  /*
  ** UPDATE spstbt ACTION
  */
  function updateSpstbtAction(){
    $content = $this->input->post();

    $this->form_validation->set_rules("title","title","trim|required|xss_clean|max_length[100] ",
    array(
      'required' => 'Title is required.',
      'max_length' => 'Title is invalid.'
    ));

    $this->form_validation->set_rules("overview","Overview","trim|xss_clean");

    $this->form_validation->set_rules("status","Status","trim|required|xss_clean|max_length[100] ",
    array(
      'required' => 'Status is not selected.',
      'max_length' => 'Status is invalid.'
    ));

    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors);
    }else{
      if(!empty($_FILES['pdf']['name'])){
        if(file_exists('./'.$content['pdf_path'])){
          $this->removeImage($content['pdf_path']);
        }
        
        $filename = $_FILES['pdf']['name'];
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        $imagename = strtotime('now');
        $img = $this->uploadFile($imagename,"pdf");
        $imgpath = 'public/custom/files/spstbt/'.$imagename.'.'.$ext;
        if($img !== 1){
          echo json_encode(array("pdf"=>$img)); exit;
        }
      }else{
        $imgpath = $content['pdf_path'];
      }

      $admin_array['logID'] = $admin['logID'];
      $admin = $this->session->userdata('admin');

      $data = array(
        'title'=> strip_tags($content['title']),
        'overview'=> strip_tags($content['overview']),
        'filepath'=> strip_tags($imgpath),
        'status'=> strip_tags($content['status']),
        'admin'=>Modules::run('admin/getAdminName',$admin['id']),
        'modifiedDate'=>date('Y-m-d H:i:s')
      );

      $insert = $this->Mdl_spstbt->update("spstbt", "id", $content['id'], $data);

      #track log
      $admin_array['userid'] = $admin['id'];
      $admin_array['usertype'] = 'admin';
      $admin_array['action_type'] = 'Update';
      $admin_array['modulename'] = 'spstbt';
      $admin_array['userip'] = $this->input->ip_address();

      $log =  insertTrackLog($admin_array);

      echo json_encode(array("status"=>"success")); exit;
    }
  }

	/*
  **  File Upload
  */
  function uploadFile($imageName,$key){
    $config['file_name'] = $imageName;
    $config['upload_path'] = './public/custom/files/spstbt';
    $config['allowed_types'] = "pdf|PDF";
    $config['max_size']  = '5000';
    
    $this->load->library('upload',$config);
    $this->upload->initialize($config);
    if (!$this->upload->do_upload($key)){
      return $this->upload->display_errors();
    }else{
      return 1;
    }
  }
}
