<?php 
namespace App\Modules\Statistics\Controllers;
ini_set("memory_limit","512M");
error_reporting(E_ALL ^ E_NOTICE);



use App\Modules\generic\Models\Mdl_generic;

use App\Modules\Statistics\Models\Mdl_statistics;

use CodeIgniter\Controller;

class Statistics extends Controller
{
   private $db;
 protected  $viewFile;
 protected  $email;
 protected  $captcha; 
 protected  $isLogin;
 
    /**
     * Constructor.
     */
    public function __construct()
    {
        //$db = \Config\Database::connect();
        $this->Mdl_statistics = new Mdl_statistics();
    }

 function index(){
    $statement = 'SELECT * FROM statistics WHERE status = "1" ORDER BY createdDate desc';
    $result = $this->Mdl_statistics->customQuery($statement);

    $data['statistics'] = $result;
    $data['seo'] = $this->Mdl_statistics->getByValue("seo","page","home");
    $data['country'] = $this->Mdl_statistics->getAllRecords("country");
    $data['viewFile'] = "statistics/statistics";
    $data['scriptFile'] = "statistics";
    $data['module'] = "statistics";
    $template = 'home';
    return view('template/'.$template, $data);
  }

	/*************************************************************************/
	/* 														ADMIN MODULE															 */
	/*************************************************************************/
	
	/*
	**	STATISTICS LISTING PAGE
	*/
	function viewall(){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }

    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);

    if(! in_array("8.1",$rights)){
      redirect('admin/dashboard','refresh');
    }

    $template = 'admin';
    $data['scriptFile'] = 'admin-statistics_v_1.0';
    $data['viewFile'] = 'statistics/list-statistics';
    $data['module'] = "statistics";
    return view('template/'.$template, $data);
  }
	
	/*
  **  GET LIST OF STATISTICS
  */
  function getStatistics(){
    $list = $this->Mdl_statistics->get_datatables();
    $data = array();
    $no = $_POST['start']; 
    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    
    #track log
    $admin_array['userid'] = $admin['id'];
    $admin_array['usertype'] = 'admin';
    $admin_array['action_type'] = 'View';
    $admin_array['modulename'] = 'Statictics';
    $admin_array['userip'] = $this->input->ip_address();

    $log =  insertTrackLog($admin_array);


    foreach ($list as $val) {
      $row = array();
      $url = base_url().'statistics/update/'.$val->id;
      $row[] = '<a class="btn btn-rounded btn-outline-success" href="'.$url.'">UPDATE</a>';
      
      if($admin['isAdmin'] !== '1'){
        $row[] = '<button class="btn btn-block btn-rounded btn-outline-danger" id="'.$val->id.'" onclick="callDeleteFunction(\'statistics\',\'id\',this.id,\'statistics\')">DELETE</button>';
      }else{
        $row[] = '';
      }

      $row[] = $val->title;
      $row[] = $val->month_year;
      
      $row[] = '<a class="btn btn-rounded btn-outline-info" target="_blank" href="'.$val->link.'"><i class="fa fa-file-pdf-o" aria-hidden="true"> VIEW </i></a>';

			if($val->status == '1'){
        $status = '<span class="badge badge-success">ACTIVE</span>';
      }else{
        $status = '<span class="badge badge-danger">DEACTIVE</span>';
      }
      $row[] = $status;
      $row[] = strtoupper($val->admin);
      $row[] = date('d-m-Y',strtotime($val->modifiedDate));
      $data[] = $row;
    }

    $output = array(
      "draw" => $_POST['draw'],
      "recordsTotal" => $this->Mdl_statistics->count_all(),
      "recordsFiltered" => $this->Mdl_statistics->count_filtered(),
      "data" => $data,
    );

    echo json_encode($output);
	}
	
  /*
  ** ADD NEW STATISTICS
  */
  function add(){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }

    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);

    if(! in_array("8.2",$rights)){
      redirect('admin/dashboard','refresh');
    }
    
    $data['viewFile'] = "statistics/add-statistics";
    $data['scriptFile'] = "admin-statistics_v_1.0";
    $data['module'] = "statistics";
    $template = 'admin';
    return view('template/'.$template, $data);
  }

  /*
  ** ADD STATISTICS ACTION
  */
  function addStatisticsAction(){
    $content = $this->input->post();

    $this->form_validation->set_rules("title","Title","trim|required|xss_clean|max_length[100] ",
    array(
      'required' => 'Title is required.',
      'max_length' => 'Title is invalid.'
    ));

    $this->form_validation->set_rules("month_year","Month & Year","trim|required|xss_clean|max_length[100] ",
    array(
      'required' => 'Month & Year is required.',
      'max_length' => 'Month & Year is invalid.'
    ));

    /*$this->form_validation->set_rules("link","File link","trim|required|xss_clean|max_length[100] ",
    array(
      'required' => 'File link is required.',
      'max_length' => 'File link is invalid.'
    ));*/

    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors); exit;
    }else{
      $admin = $this->session->userdata('admin');
      if(!empty($_FILES['pdf']['name']))
      {
        $filename = $_FILES['pdf']['name'];
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        //$imagename = strtotime('now');
        $imagename = pathinfo($filename, PATHINFO_FILENAME);
        $img = $this->uploadFile($imagename,"pdf");
        $imgpath = 'public/custom/files/statistics/'.$imagename.'.'.$ext;
        if($img !== 1)
        {
          echo json_encode(array("pdf"=>$img)); exit;
        }
      }
      /*else{
        echo json_encode(array("pdf"=>"Please upload file")); exit;
      } */

      $data = array(
        'title'=> strip_tags($content['title']),
        'month_year'=> strip_tags($content['month_year']),
        //'link'=> strip_tags($content['link']),
        'filepath'=> strip_tags($imgpath),
        'status'=> '1',
        'admin'=>Modules::run('admin/getAdminName',$admin['id']),
        'createdDate'=>date('Y-m-d H:i:s'),
        'modifiedDate'=>date('Y-m-d H:i:s')
      );

      $insert = $this->Mdl_statistics->insert("statistics", $data);
$insertId = $this->db->insert_id();
      #track log
      $admin_array['userid'] = $admin['id'];
      $admin_array['usertype'] = 'admin';
      $admin_array['action_type'] = 'Insert';
      $admin_array['modulename'] = 'Statictics';
      $admin_array['event_id'] = $insertId;
      $admin_array['userip'] = $this->input->ip_address();

      $log =  insertTrackLog($admin_array);

      echo json_encode(array("status"=>"success")); exit;
    }
  }
  
  /*
  ** UPDATE STATISTICS
  */
  function update($id){
    if(!Modules::run('security/isAdmin')){
      redirect('admin','refresh');
    }

    $admin_array['logID'] = $admin['logID'];
    $admin = $this->session->userdata('admin');
    $arr = $admin['rights'];
    $rights = explode(',',$arr);
    
    if(! in_array("8.3",$rights)){
      redirect('admin/dashboard','refresh');
    }

    $result = $this->Mdl_statistics->getByValue("statistics","id",$id);
    if($result == "No Data"){
      redirect('errors','refresh');
    }else{
      $data['statistics'] = $result;
      $data['viewFile'] = "statistics/update-statistics";
      $data['scriptFile'] = "admin-statistics_v_1.0";
      $data['module'] = "statistics";
      $template = 'admin';
      return view('template/'.$template, $data);
    }
  }

  /*
  ** UPDATE STATISTICS ACTION
  */
  function updateStatisticsAction(){
    $content = $this->input->post();

    $this->form_validation->set_rules("title","title","trim|required|xss_clean|max_length[100] ",
    array(
      'required' => 'Title is required.',
      'max_length' => 'Title is invalid.'
    ));

    $this->form_validation->set_rules("month_year","Month & Year","trim|required|xss_clean|max_length[100] ",
    array(
      'required' => 'Month & Year is required.',
      'max_length' => 'Month & Year is invalid.'
    ));

    /*$this->form_validation->set_rules("link","File link","trim|required|xss_clean|max_length[100] ",
    array(
      'required' => 'File link is required.',
      'max_length' => 'File link is invalid.'
    ));*/

    $this->form_validation->set_rules("status","Status","trim|required|xss_clean|max_length[100] ",
    array(
      'required' => 'Status is not selected.',
      'max_length' => 'Status is invalid.'
    ));

    if($this->form_validation->run() == FALSE){
      $errors = $this->form_validation->error_array();
      echo json_encode($errors); exit;
    }else{
      $admin_array['logID'] = $admin['logID'];
      $admin = $this->session->userdata('admin');
      
      if(!empty($_FILES['pdf']['name'])){
        if(file_exists('./'.$content['pdf_path'])){
          $this->removeImage($content['pdf_path']);
        }
        
        $filename = $_FILES['pdf']['name'];
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        //$imagename = strtotime('now');
        $imagename = pathinfo($filename, PATHINFO_FILENAME);
        $img = $this->uploadFile($imagename,"pdf");
        $imgpath = 'public/custom/files/statistics/'.$imagename.'.'.$ext; 
        if($img !== 1){
          echo json_encode(array("pdf"=>$img)); exit;
        }
      }else{
        $imgpath = $content['pdf_path']; 
      }

      $data = array(
        'title'=> strip_tags($content['title']),
        'month_year'=> strip_tags($content['month_year']),
        //'link'=> strip_tags($content['link']),
        'filepath'=> strip_tags($imgpath),
        'status'=> strip_tags($content['status']),
        'admin'=>Modules::run('admin/getAdminName',$admin['id']),
        'modifiedDate'=>date('Y-m-d H:i:s')
      );

      $insert = $this->Mdl_statistics->update("statistics", "id", $content['id'], $data);

      #track log
      $admin_array['userid'] = $admin['id'];
      $admin_array['usertype'] = 'admin';
      $admin_array['action_type'] = 'Update';
      $admin_array['modulename'] = 'Statictics';
      $admin_array['userip'] = $this->input->ip_address();

      $log =  insertTrackLog($admin_array);

      echo json_encode(array("status"=>"success")); exit;
    }
  }
  
  
  /*
  **  File Upload
  */
  function uploadFile($imageName,$key){
    $config['file_name'] = $imageName;
    $config['upload_path'] = './public/custom/files/statistics';
    $config['allowed_types'] = "pdf|PDF";
    $config['max_size']  = '10000';
    
    $this->load->library('upload',$config);
    $this->upload->initialize($config);
    if (!$this->upload->do_upload($key)){
      return $this->upload->display_errors();
    }else{
      return 1;
    }
  }

}
