<?php namespace App\Modules\Template\Controllers;

use App\Modules\Template\Models\UserPagesModel;
use CodeIgniter\Controller;

class Template extends Controller
{
    private $userModel;

    /**
     * Constructor.
     */
    public function __construct()
    {
        $this->userPagesModel = new UserPagesModel();
    }

    public function index()
	{
		$data = [
		    'title' => 'Dashboard Page',
            'view' => 'pages/organization',
            'data' => $this->userPagesModel->getPagesUsers(),
        ];

		return view('template/layout', $data);
	}
    
    
    function home($data){
		 $salt = $this->session->userdata('salt');
        $token= $this->session->userdata("foot_message_token"); 
        $data['salt'] = $token;
		$captcha = Modules::run('captcha/Captcha');
      	$data['captcha'] = $captcha;
		$this->load->view('home',$data);

	}


    // test home template
function hometest($data){
		
		$captcha = Modules::run('captcha/Captcha');
      	$data['captcha'] = $captcha;
		$this->load->view('hometest',$data);

	}

	/*

	**	Innerpage Template 

	*/

	function blog($data){

		$this->load->view('blog',$data);

	}



	/*

  **  Error Template 

  */

  function errors($data){

    $this->load->view('errors',$data);

	}

	

	/*

	**	Admin Template 

	*/

	function admin($data){	

		$this->load->view('admin', $data);

	}


	
	function refresh_captcha(){
		$content = $this->input->post();
		
		if($content['req'] == 1){
		  $captcha = Modules::run('captcha/Captcha');
		  echo json_encode(array("status"=>"success", "message" => '', 'res' => $captcha)); exit;
		}else{
		  echo json_encode(array("status"=>"fail", "message" => 'Something went wrong !', "res" => $captcha)); exit;
		}

		echo $captcha;
		  
	}	
}
