<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Mdl_generic extends CI_Model{

	function __construct() {
		parent::__construct();
		$this->load->model('Mdl_generic');
	}
	
	/*
	**	Insert Query 
	*/
	function insert($table, $data) {
		$this->db->insert($table, $data);
		$id = $this->db->insert_id();
		return $id;
	}
	
	/*
	**	Update Query 
	*/
	function update($table, $col, $val, $data) {
		$this->db->where($col, $val);
		return $this->db->update($table, $data);
	}
	
	/*
	**	Delete By Id Query 
	*/
	function deleteById($table, $col, $val) {
		$this->db->where($col, $val);
		$this->db->delete($table);
	}
	
	/*
	**	Get Record By Value Query 
	*/
	function getByValue($table, $col, $val){
		$this->db->where($col, $val);
		$query=$this->db->get($table);
		if($query->num_rows() > 0){
			return $query->result(); 
		}else{
			return "No Data";
		} 
	}

	/*
	**	Get Record By Values Query 
	*/
	function getByValues($table, $param) {
		foreach($param as $key => $value){
			$this->db->where($key, $value);
		}
		$query=$this->db->get($table);
		if($query->num_rows() > 0){
			return $query->result(); 
		}else{
			return "No Data";
		} 
	}

	/*
	**	Get All Records Query 
	*/
	function getAllRecords($table) {
		$query=$this->db->get($table);
		if($query->num_rows() > 0){
			return $query->result(); 
		}else{
			return "No Data";
		} 
	}
	
	/*
	**	isExist Query
	*/
	function isExist($table, $col, $val){
		$this->db->where($col, $val);
		$query=$this->db->get($table);
		if($query->num_rows() > 0){
			return TRUE; 
		}else{
			return FALSE;
		} 
	}
	
	/*
	**	Active Query
	*/
	function active($table, $col, $val){
		$this->db->where($col, $val);
		return $this->db->update($table, array('isActive'=>'1'));
	}
	
	/*
	**	Inactive Query
	*/
	function inactive($table, $col, $val){
		$this->db->where($col, $val);
		return $this->db->update($table, array('isActive'=>'0'));
	}
	
	/*
	**	Custom Query
	*/
	function customQuery($mysql_query) {
		$query = $this->db->query($mysql_query);
		if($query->num_rows() > 0){
			return $query->result(); 
    }else{
      return "No Data";
    }
	}

  function count($table){
    return $this->db->count_all_results($table);
	}
}