var table, table_1;

$(document).ready(function(){
  table = $("#advertiseTable").DataTable({
    "paging":   true,
    "scrollX": true,
    "scrollY": false,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'advertise/getAdvertise',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0],"width":60},
      {"targets":[1],"width":60},
      {"targets":[2],"width":300},
      {"targets":[3],"width":100},
      {"targets":[4,5],"width":150}
    ],
    dom: 'Bfrtip',
    buttons: []
  });

  table_1 = $("#advertiseEnquiryTable").DataTable({
    "paging":   true,
    "scrollX": true,
    "scrollY": false,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'advertise/getAdvertiseEnquiry',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0],"width":80},
      {"targets":[1],"width":100},
      {"targets":[2],"width":150},
      {"targets":[3],"width":200},
      {"targets":[4],"width":200},
      {"targets":[5],"width":150}
    ],
    dom: 'Bfrtip',
    buttons: []
  });

  $("#add_advertise").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "advertise/addAdvertiseAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn();
      },
      success: function(result) {
      	$(".preloader").fadeOut();
      	
        if(result.status == "success"){
          window.location.href = CI_ROOT + "advertise/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_advertise").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "advertise/updateAdvertiseAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn();
      },
      success: function(result) {
      	$(".preloader").fadeOut();
      	
        if(result.status == "success"){
          window.location.href = CI_ROOT + "advertise/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
});