var table;

$(document).ready(function(){
  table_1 = $('#bannerTable').DataTable({ 
    "paging":   true,
    "scrollX": true,
    "processing": true, 
    "serverSide": true, 
    "order":[],
    "ajax": {
      "url": CI_ROOT+'banner/getBanners',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {targets:[0],width:50},
      {targets:[1],width:50},
      {targets:[2],width:60},
      {targets:[3],width:500},
      {targets:[4],width:100},
      {targets:[5],width:130}
    ],
    dom: 'Bfrtip',  
    buttons: []
  });

  $("#add_banner").on("submit",function(e){
    e.preventDefault();  
    $(".error").html("");
    $(".error").css("display","none");
    
    var formdata = new FormData(this);
   
    $.ajax({
      type:'POST',
      data:formdata,
      url:CI_ROOT+"banner/addBannerAction",
      mimeType : 'multipart/form-data',
      contentType: false,
      processData: false,
      dataType: "json",
      beforeSend:function(){
       $(".preloader").fadeIn(); 
      },
      success:function(result){
        $(".preloader").fadeOut(); 
        if(result.status == "success"){
          window.location.href= CI_ROOT + 'banner/list';
        }else{
          $.each(result, function(i, v) {
            $("label[for='"+i+"']").html(v);
          });
                    
          var keys = Object.keys(result);
          $(".error").css("display","block");
          $('input[name="'+keys[0]+'"]').focus();
        }
      }
    });
  });

  $("#update_banner").on("submit",function(e){
    e.preventDefault();     
    $(".error").html("");
    $(".error").css("display","none");
    
    var formdata = new FormData(this);
   
    $.ajax({
      type:'POST',
      data:formdata,
      url:CI_ROOT+"banner/updateBannerAction",
      mimeType : 'multipart/form-data',
      contentType: false,
      processData: false,
      dataType: "json",
      beforeSend:function(){
       $(".preloader").fadeIn(); 
      },
      success:function(result){ 
        $(".preloader").fadeOut(); 
        if(result.status == "success"){
          window.location.href= CI_ROOT + 'banner/list';
        }else{
          $.each(result, function(i, v) {
            $("label[for='"+i+"']").html(v);
          });
                    
          var keys = Object.keys(result);
          $(".error").css("display","block");
          $('input[name="'+keys[0]+'"]').focus();
        }
      }
    });
  });
}); 
