var table_1, table_2;
$(document).ready(function(){
  table_1 = $("#designationTable").DataTable({
    "paging":   false,
    "scrollX": true,
    "scrollY": 400,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'coa/getDesignations',
      "type": "POST",
      "data": function(data){
        data.parent = $('#designation-filter-1').val();
      }
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0,1,3],"width":80},
      {"targets":[2],"width":200},
      {"targets":[4,5],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });
  
  $("#designation-filter-1").on("change",function(e){
    table_1.ajax.reload();
  });

  $("#designation-filter-2").on("change",function(e){
    table_2.ajax.reload();
  });

  $("#add_designation").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "coa/addDesignationAction",
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn();
      },
      success:function(result){  
        $(".preloader").fadeOut();

        if(result.status == "success"){
          window.location.href = CI_ROOT + "coa/designations";
        }else if(result.status == "invalid"){
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          
          var t = Object.keys(e);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        } 
      }
    })
  });

  $("#add_division").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "coa/addDivisionAction",
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn();
      },
      success:function(result){  
        $(".preloader").fadeOut();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "coa/designations";
        }else if(result.status == "invalid"){
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          
          var t = Object.keys(e);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        } 
      }
    })
  });
  
  $("#update_designation").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");
    alert('submited');
    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "coa/updateDesignationAction",
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn();
      },
      success:function(result){  
        $(".preloader").fadeOut();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "coa/designations";
        }else if(result.status == "invalid"){
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          
          var t = Object.keys(e);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
          $(".preloader").hide();
        } 
      }
    })
  });

  table_2 = $("#coaTable").DataTable({
    "paging":   false,
    "scrollX": true,
    "scrollY": 500,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'coa/getCOA',
      "type": "POST",
      "data": function(data){
        data.parent = $('#designation-filter-2').val();
      }
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0,1],"width":80},
      {"targets":[2],"width":100},
      {"targets":[3,4],"width":150},
      {"targets":[5],"width":80},
      {"targets":[6,7],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });

  $("#designation").on("change",function(e){
    e.preventDefault();
    var selected = $("#designation").val();

    if(selected !== ""){
      $.ajax({
        type:'POST',
        data:{designation:selected},
        url:CI_ROOT+"coa/getDivisionList",
        dataType: "json",
      
        success:function(result){    
          if(result.status == "fail"){
            $('#division').empty();
            $('#division').append('<option value="">SELECT DIVISION</option>');
            $("#division_div").hide();
          }else{
            $('#division').empty();
            $('#division').append('<option value="">SELECT DIVISION</option>');
            $.each(result, function(i, v) {
              $('#division').append('<option value="'+i+'">'+v+'</option>');
            });
            $("#division_div").show();
          }
        }
      });
    }else{
      $('#division').empty();
      $('#division').append('<option value="">SELECT DIVISION</option>');
      $("#division_div").hide();
    }
  });
  
  $("#add_coa").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "coa/addCOAAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn()
      },
      success: function(result) {
        $(".preloader").fadeOut();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "coa/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_coa").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "coa/updateCOAAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn()
      },
      success: function(result) {
        $(".preloader").fadeOut();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "coa/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
});