var table;
$(document).ready(function(){
  table = $("#educationTable").DataTable({
    "paging":   true,
    "scrollX": true,
    "scrollY": false,
    "processing": true, 
    "serverSide": true, 
    "pageLength": 20, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'education/geteducation',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0,1],"width":60},
      {"targets":[2],"width":350},
      {"targets":[3],"width":100},
      {"targets":[4],"width":80},
      {"targets":[5,6],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });
  
    
  $('#from_date').datepicker({
    uiLibrary: 'bootstrap4',
    format: 'dd-mm-yyyy'
  });

  $('#to_date').datepicker({
    uiLibrary: 'bootstrap4',
    format: 'dd-mm-yyyy'
  });
  
  $("#add_education").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "education/addeducationAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn()
      },
      success: function(result) {
        $(".preloader").fadeOut();
        
        if(result.status == "success"){
          window.location.href = CI_ROOT + "education/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_education").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "education/updateeducationAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn();
      },
      success: function(result) {
        $(".preloader").fadeOut();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "education/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  
  
  $("#memberprice").on("keyup",function(){
    var memberprice    =    $("#memberprice").val();  
    var memberdiscount =    $("#memberdiscount").val();
    var gst            =    $("#gst").val();
    if(memberdiscount > 0)
    {
        if(gst > 0)
        {
            var totalgstamt =   parseFloat(memberprice) * parseFloat(gst) /100;
            var totalamtaftergst    =   parseFloat(memberprice) + parseFloat(totalgstamt);
            var discount   =   parseFloat(memberprice) * parseFloat(memberdiscount)/ 100;
            var membertotalprice   =   parseFloat(totalamtaftergst) - parseFloat(discount);
        }
        else
        {
            var discount   =   parseFloat(memberprice) * parseFloat(memberdiscount)/ 100;
            var membertotalprice   =   parseFloat(memberprice) - parseFloat(discount);
        }    
    }
    else
    {
        if(gst > 0)
        {
            var totalgstamt =   parseFloat(memberprice) * parseFloat(gst) /100;
            var totalamtaftergst    =   parseFloat(memberprice) + parseFloat(totalgstamt);
            var membertotalprice   =   parseFloat(totalamtaftergst);
        }
        else
        {
            var membertotalprice   =   parseFloat(memberprice);
        }    
    }
    $("#membertotalprice").val(membertotalprice);
     
  }); 
  
  $("#nonmemberprice").on("keyup",function(){
    var memberprice    =    $("#nonmemberprice").val();  
    var memberdiscount =    $("#nonmemberdiscount").val();
    var gst            =    $("#gst").val();
    if(memberdiscount > 0)
    {
        if(gst > 0)
        {
            var totalgstamt =   parseFloat(memberprice) * parseFloat(gst) /100;
            var totalamtaftergst    =   parseFloat(memberprice) + parseFloat(totalgstamt);
            var discount   =   parseFloat(memberprice) * parseFloat(memberdiscount)/ 100;
            var membertotalprice   =   parseFloat(totalamtaftergst) - parseFloat(discount);
        }
        else
        {
            var discount   =   parseFloat(memberprice) * parseFloat(memberdiscount)/ 100;
            var membertotalprice   =   parseFloat(memberprice) - parseFloat(discount);
        }    
    }
    else
    {
        if(gst > 0)
        {
            var totalgstamt =   parseFloat(memberprice) * parseFloat(gst) /100;
            var totalamtaftergst    =   parseFloat(memberprice) + parseFloat(totalgstamt);
            var membertotalprice   =   parseFloat(totalamtaftergst);
        }
        else
        {
            var membertotalprice   =   parseFloat(memberprice);
        }    
    }
    $("#nonmembertotalprice").val(membertotalprice);
     
  }); 
  
});