var table, table_1;

$(document).ready(function(){
  table = $("#exhibitionsTable").DataTable({
    "paging":   true,
    "scrollX": true,
    "scrollY": false,
    "processing": true, 
    "serverSide": true,
    "pageLength": 20,
    "order": [],
    "ajax": {
      "url": CI_ROOT+'exhibitions/getExhibitions',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0,1],"width":80},
      {"targets":[2],"width":100},
      {"targets":[3],"width":200},
      {"targets":[4],"width":150},
      {"targets":[5],"width":150},
      {"targets":[6],"width":80}, 
      {"targets":[7,8],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });

  table_1 = $("#exhibitionEnquiry").DataTable({
    "paging":   true,
    "scrollX": true,
    "scrollY": false,
    "processing": true, 
    "serverSide": true, 
    "pageLength": 20,
    "order": [],
    "ajax": {
      "url": CI_ROOT+'exhibitions/getExhibitionEnquiry',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0,1],"width":80},
      {"targets":[2],"width":200},
      {"targets":[3],"width":200},
      {"targets":[4],"width":200},
      {"targets":[5],"width":150},
      {"targets":[6],"width":150}, 
      {"targets":[7],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });
  
  $('#from_date').datepicker({
    uiLibrary: 'bootstrap4',
    format: 'dd-mm-yyyy'
  });

  $('#to_date').datepicker({
    uiLibrary: 'bootstrap4',
    format: 'dd-mm-yyyy'
  });

  $("#add_exhibition").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "exhibitions/addExhibitionAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn()
      },
      success: function(result) {
        $(".preloader").fadeOut();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "exhibitions/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_exhibition").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "exhibitions/updateExhibitionsAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn()
      },
      success: function(result) {
        $(".preloader").fadeOut();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "exhibitions/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
});