var table_1, table_2;
$(document).ready(function(){
  table_1 = $("#designationTable").DataTable({
    "paging":   true,
    "scrollX": true,
    "scrollY": false,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'secretariat/getDesignations',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0,1],"width":80},
      {"targets":[2],"width":200},
      {"targets":[3],"width":60},
      {"targets":[4,5],"width":120}
    ],
    dom: 'Bfrtip',
    buttons: []
  });

  $("#add_designation").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "secretariat/addDesignationAction",
      dataType: "json",
      beforeSend: function(){
        $(".preloader").show();
      },
      success:function(result){  
        if(result.status == "success"){
          $(".preloader").hide();
          window.location.href = CI_ROOT + "secretariat/designations";
        }else if(result.status == "invalid"){
          $(".preloader").hide();
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          
          var t = Object.keys(e);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
          $(".preloader").hide();
        } 
      }
    })
  });
  
  $("#update_designation").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "secretariat/updateDesignationAction",
      dataType: "json",
      beforeSend: function(){
        $(".preloader").show();
      },
      success:function(result){  
        if(result.status == "success"){
          $(".preloader").hide();
          window.location.href = CI_ROOT + "secretariat/designations";
        }else if(result.status == "invalid"){
          $(".preloader").hide();
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          
          var t = Object.keys(e);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
          $(".preloader").hide();
        } 
      }
    })
  });

  table_2 = $("#secretariatTable").DataTable({
    "paging":   true,
    "scrollX": true,
    "scrollY": false,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'secretariat/getSecretariat',
      "type": "POST",
      "data": function(data){
        data.parent = $('#designation-filter-2').val();
      }
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0,1],"width":80},
      {"targets":[2],"width":100},
      {"targets":[3,4],"width":150},
      {"targets":[5],"width":80},
      {"targets":[6,7],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });

  $("#designation-filter-2").on("change",function(e){
    table_2.ajax.reload();
  });
  
  $("#add_secretariat").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "secretariat/addSecretariatAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn()
      },
      success: function(result) {
        $(".preloader").fadeOut();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "secretariat/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_secretariat").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "secretariat/updateSecretariatAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn()
      },
      success: function(result) {
        $(".preloader").fadeOut();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "secretariat/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
});