var table, table_1;

$(document).ready(function(){
  table = $("#tradeDelegationTable").DataTable({
    "paging":   true,
    "scrollX": true,
    "scrollY": false,
    "processing": true, 
    "serverSide": true, 
    "pageLength": 20, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'tradedelegation/getTradeDelegations',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0,1],"width":60},
      {"targets":[2],"width":100},
      {"targets":[3],"width":200},
      {"targets":[4],"width":250},
      {"targets":[5],"width":250},
      {"targets":[6],"width":80}, 
      {"targets":[7,8],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });

  table_1 = $("#tradeEnquiry").DataTable({
    "paging":   true,
    "scrollX": true,
    "scrollY": false,
    "processing": true, 
    "serverSide": true, 
    "pageLength": 20, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'tradedelegation/getTradeEnquiry',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0,1],"width":60},
      {"targets":[2],"width":200},
      {"targets":[3],"width":200},
      {"targets":[4],"width":150},
      {"targets":[5],"width":150},
      {"targets":[6],"width":150}, 
      {"targets":[7],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });
  
  $('#from_date').datepicker({
    uiLibrary: 'bootstrap4',
    format: 'dd-mm-yyyy'
  });

  $('#to_date').datepicker({
    uiLibrary: 'bootstrap4',
    format: 'dd-mm-yyyy'
  });

  $("#add_trade_delegation").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "tradedelegation/addTradeDelegationAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn()
      },
      success: function(result) {
        $(".preloader").fadeOut();

        if(result.status == "success"){
          window.location.href = CI_ROOT + "trade-delegation/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_trade_delegation").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "tradedelegation/updateTradeDelegationAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn()
      },
      success: function(result) {
        $(".preloader").fadeOut();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "trade-delegation/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
});