var table;
$(document).ready(function() {
  var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
  $('.js-switch').each(function() {
    new Switchery($(this)[0], $(this).data());
  });

  table = $("#adminTable").DataTable({
    "paging":   true,
    "scrollX": true,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url" : CI_ROOT + "admin/getAdminList",
      "type": "POST"
    },
    "columnDefs": [
      { "targets": "_all", "orderable":false},
      { "targets": [0], "width":60},
      { "targets": [1], "width":60},
      { "targets": [2], "width":60},
      { "targets": [3], "width":150},
      { "targets": [4], "width":100},
      { "targets": [5], "width":100}
    ],
    dom: "Bfrtip",
    buttons: []
  }); 
    
  $("#add_admin").on("submit", function(e) {
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "admin/addAdminAction",
      dataType: "json",
      beforeSend: function() {
        $(".preloader").fadeIn();
      },
      success: function(response){
        $(".preloader").fadeOut();
        if(response.status == "success"){
          window.location.href = CI_ROOT + "admin/list";
        }else if("invalid" == response.status){
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(response, function(e, t) {
            $("label[for='"+e+"']").html(t);
          });
          
          var t = Object.keys(response);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#edit_admin").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "admin/editAdminAction",
      dataType: "json",
      beforeSend: function(){
        $(".preloader").fadeIn();
      },
      success: function(response) {
        $(".preloader").fadeOut();
        if ("success" == response.status){
          window.location.href = CI_ROOT + "admin/list";
        }else if("invalid" == response.status){
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(response, function(e, t) {
            $("label[for='" + e + "']").html(t); 
          });
          
          var t = Object.keys(response);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    });
  });

    
    
    
  $("#change_pass").on("submit", function(e) {
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");
    
    let op = admincrypt($('#opword').val());
    let np = admincrypt($('#npword').val());
    let cnp = admincrypt($('#cnpword').val());
    
    $("#opword").val(op);
    $("#npword").val(np);
    $("#cnpword").val(cnp);
    
    //let hashp = cryptsalt(op);
   // $("#hash").val(cnp);
    
    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "admin/changePasswordAction",
      dataType: "json",
      beforeSend: function() {
        $(".preloader").fadeIn();
      },
      success: function(response) {
        $(".preloader").fadeOut();
        if("success" == response.status){
          window.location.href = CI_ROOT + "admin/dashboard";
        }else if("invalid" == response.status){
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else if("error" == response.status){
            swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Please Enter different password. Password is already exist !."
            });
        }else{
          $.each(response, function(e, t) {
            $("label[for='" + e + "']").html(t); 
          });
          
          var t = Object.keys(response);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    });
  });

  $("#update_magazine").on("submit", function(e) {
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "admin/updateMagazine",
      dataType: "json",
      beforeSend: function() {
        $(".preloader").fadeIn();
      },
      success: function(response) {
        $(".preloader").fadeOut();
        if("success" == response.status){
          window.location.href = CI_ROOT + "admin/dashboard";
        }else if("invalid" == response.status){
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(response, function(e, t) {
            $("label[for='" + e + "']").html(t); 
          });
          
          var t = Object.keys(response);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    });
  });
});