$(document).ready(function(){

  $('#horizontalTab').easyResponsiveTabs({
    type: 'default', //Types: default, vertical, accordion           
    width: 'auto', //auto or any width like 600px
    fit: true,   // 100% fit in a container
    closed: 'accordion', // Start closed if in accordion view
    activate: function(event) { // Callback function if tab is switched
      var $tab = $(this);
      var $info = $('#tabInfo');
      var $name = $('span', $info);
      $name.text($tab.text());
      $info.show();
    }
  });

  $('a.archive').click(function(event){
		event.preventDefault();
		$('.mediaCenterData').slideToggle();
  });
	
	$('.mediaCenterData h4').click(function(){
		$('.articleData').slideUp();
		$('.mediaCenterData h4').children('span').text('+');

    if($(this).next('.articleData').is(':visible')){
			$(this).next('.articleData').slideUp();
			$(this).children('span').text('+');
			$(this).children('span').removeClass('bigFont');
		}else{
			$(this).next('.articleData').slideDown();
			$(this).children('span').text('-');
			$(this).children('span').addClass('bigFont');
			}
  });
});

var year;

$(document).ready(function(){
  year = $('.resp-tab-active').children().text();
  //alert(year);
  loadgetArticlesData(year);

  $('.slider').slick({
    slidesToShow: 5,
    slidesToScroll: 1,
    arrows: false,
    dots:false,
  
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 5,
        }
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 400,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 320,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
    ]
  });

  $('.next').click(function(){
    $('.slider').slick('slickPrev');
  })
  
  $('.previous').click(function(){
    $('.slider').slick('slickNext');
  })

  $('.slider li').click(function(){
		$('.slider li').removeClass('resp-tab-active');
    $(this).addClass('resp-tab-active');
    year = $(this).children().text();
    loadgetArticlesData(year);
  });
  
  $('.radioBtn').click(function(){
    $('.radioBtn').removeClass('whiteColor');
    $(this).addClass('whiteColor');
  });
});

function loadgetArticlesData(year){
  $.ajax({
    type: "POST",
    data: {year:year},
    url: CI_ROOT + "articles/get",
    dataType: "json",
    beforeSend:function(){
      $("#preloader").show(); 
      $("#status").show(); 
    },
    success:function(result){  
      $("#preloader").hide(); 
      $("#status").fadeOut();

      if(result.status == "success"){
        $("#responseData").html('');
        $("#responseData").html(result.response);
      }else if(result.status == "fail"){
        $("#responseData").html('<h2 class="pt-4" style="color:#ccc">Data Not Available.</h2>');
      }else{
        $("#responseData").html('<h2 class="pt-4" style="color:#ccc">Data Not Available.</h2>');
      } 
    }
  });
}