var product = '';
var cname = '';
var city = '';
var region = '';
var sort = '';

$(document).ready(function(){
  firstLoad();

  $("#searchForm").on("submit",function(e){
    e.preventDefault();        
    
    product = $("#product").val();
    cname = $("#cname").val();
    city = $("#city").val();
    region = $("#region").val();
    sort = $("#sort").val();
    var page = 1;

    $("#total").html('Please wait ....');
  
    $.ajax({
      type:'POST',
      data:{product : product,
      cname : cname,
      city : city,
      region : region,
      sort : sort,
      page : page},
      url:CI_ROOT+"member/getDirectorySearchData",
      dataType: "json",
      beforeSend:function(){
        $("#preloader").show(); 
        $("#status").show(); 
      },
      success:function(result){
        if(result.status == "success"){
          $("#member_content").html('');
          $("#pagination_link").html('');
          $("#total").html(result.total+' Members Found');
          $("#member_content").html(result.data);
          $("#pagination_link").html(result.pagination);
        }else if(result.status == "fail"){
          $("#member_content").html('');
          $("#pagination_link").html('');
          $("#total").html('0 Members Found');
        }
  
        $("#preloader").hide(); 
        $("#status").fadeOut();
      }
    });
  });

  $("input[type='reset']").closest('form').on('reset', function(event) {
    product = '';
    cname = '';
    city = '';
    region = '';
    sort = '';
    firstLoad();
  });
});

function firstLoad(){
  var page = '1';

  $("#total").html('Please wait ....');

  $.ajax({
    type:'POST',
    data:{product : product,
    cname : cname,
		city : city,
		region : region,
		sort : sort,
    page : page},
    url:CI_ROOT+"member/getDirectories",
    dataType: "json",
    beforeSend:function(){
      $("#preloader").show(); 
      $("#status").show(); 
    },
    success:function(result){
      if(result.status == "success"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html(result.total+' Members Found');
        $("#member_content").html(result.data);
        $("#pagination_link").html(result.pagination);
      }else if(result.status == "fail"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html('0 Members Found');
      }

      $("#preloader").hide(); 
      $("#status").fadeOut();
    }
  });
}

function paginate(page,e){
  $("#total").html('Please wait ....');
  if(page == "prev"){
    page = $(".activetxt").text();
    page = page - 1;
  }else if(page == "next"){
    page = $(".activetxt").text();
    page = page + 1;
  }

  $.ajax({
    type:'POST',
    data:{product : product,
    cname : cname,
    city : city,
    region : region,
    sort : sort,
    page : page},
    url:CI_ROOT+"member/getDirectories",
    dataType: "json",
    beforeSend:function(){
      $("#preloader").show(); 
      $("#status").show(); 
    },
    success:function(result){
      if(result.status == "success"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html(result.total+' Members Found');
        $("#member_content").html(result.data);
        $("#pagination_link").html(result.pagination);
      }else if(result.status == "fail"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html('0 Members Found');
      }

      $("#preloader").hide(); 
      $("#status").fadeOut();
    }
  });
}

function searchPaginate(page,e){
  product = $("#product").val();
  cname = $("#cname").val();
  city = $("#city").val();
  region = $("#region").val();
  sort = $("#sort").val();

  $("#total").html('Please wait ....');

  if(page == "prev"){
    page = $(".activetxt").text();
    page = page - 1;
  }else if(page == "next"){
    page = $(".activetxt").text();
    page = page + 1;
  }

  $.ajax({
    type:'POST',
    data:{product : product,
    cname : cname,
    city : city,
    region : region,
    sort : sort,
    page : page},
    url:CI_ROOT+"member/getDirectorySearchData",
    dataType: "json",
    beforeSend:function(){
      $("#preloader").show(); 
      $("#status").show(); 
    },
    success:function(result){
      if(result.status == "success"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html(result.total+' Members Found');
        $("#member_content").html(result.data);
        $("#pagination_link").html(result.pagination);
      }else if(result.status == "fail"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html('0 Members Found');
      }

      $("#preloader").hide(); 
      $("#status").fadeOut();
    }
  });
}

function showData(ref){
  $(".error").html("");
  $(".error").css("display","none");  
  
  $('#memberEnquiryForm')[0].reset();
  $("#member_name").val($("#"+ref).data("name"));
  $("#member_email").val($("#"+ref).data("email"));
  $("#member_name").prop("readonly", true);
}

$(document).ready(function(){
  $("#enquiry_otp_resend").hide();
  $("#enquiry_otp_text").hide();

  $("#enquiry_otp_send").on("click", function(e) {
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var enquiry_mobile = $("#enquiry_mobile").val();
    var enquiry_country = $("#enquiry_country").val();
    
    $.ajax({
      type: 'POST',
      data: {
        enquiry_mobile: enquiry_mobile,
        enquiry_country: enquiry_country
      },
      url: CI_ROOT + "member/generateEnquiryOtp",
      dataType: "json",
      beforeSend: function() {
        $("#preloader").show();
        $("#status").show()
      },

      success: function(result) {
        $("#preloader").hide();
        $("#status").fadeOut();

        if (result.status == "success") {
          $("#otp_sent").val("yes");
          $("#enquiry_otp_send").hide();
          $("#enquiry_otp_resend").show();
          $("#enquiry_otp_text").show();
        } else if (result.status == "error") {
          $('label[for="general_error"]').html(result.msg);
          $(".error").css("display", "block");
        } else if (result.status == "invalid") {
          $('label[for="general_error"]').html("Something went wrong. Please try again.");
          $(".error").css("display", "block");
        } else if (result.status == "blocked") {
          $('label[for="enquiry_mobile"]').html("Your mobile no is blocked as you have reached maximum attempt limit for otp verification");
          $(".error").css("display", "block");
        } else {
          $.each(result, function(i, v) {
            $('label[for="'+i+'"]').html(v);
          });
          var keys = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + keys[0] + '"]').focus()
        }
      }
    })
    
  });

  $("#enquiry_otp_resend").on("click", function(e) {
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var enquiry_mobile = $("#enquiry_mobile").val();
    var enquiry_country = $("#enquiry_country").val();
    
    $.ajax({
      type: 'POST',
      data: {
        enquiry_mobile: enquiry_mobile,
        enquiry_country: enquiry_country
      },
      url: CI_ROOT + "member/resendEnquiryOtp",
      dataType: "json",
      beforeSend: function() {
        $("#preloader").show();
        $("#status").show()
      },

      success: function(result) {
        $("#preloader").hide();
        $("#status").fadeOut();

        if (result.status == "success") {
          $("#otp_sent").val("yes");
          $("#enquiry_otp_send").hide();
          $("#enquiry_otp_resend").show();
          $("#enquiry_otp_text").show();
        } else if (result.status == "error") {
          $('label[for="general_error"]').html(result.msg);
          $(".error").css("display", "block");
        } else if (result.status == "invalid") {
          $('label[for="general_error"]').html("Something went wrong. Please try again.");
          $(".error").css("display", "block");
        } else if (result.status == "blocked") {
          $('label[for="enquiry_mobile"]').html("Your mobile no is blocked as you have reached maximum attempt limit for otp verification");
          $(".error").css("display", "block");
        } else {
          $.each(result, function(i, v) {
            $('label[for="'+i+'"]').html(v);
          });
          var keys = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + keys[0] + '"]').focus()
        }
      }
    })
    
  });

  $("#memberEnquiryForm").on("submit", function(e) {
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var formdata = $(this).serialize();
    
    $.ajax({
      type: 'POST',
      data:formdata,
      url: CI_ROOT + "member/enquiryAction",
      dataType: "json",
      beforeSend: function() {
        $("#preloader").show();
        $("#status").show()
      },

      success: function(result) {
        $("#preloader").hide();
        $("#status").fadeOut();

        if (result.status == "verify_mobile") {
          $('label[for="enquiry_mobile"]').html("Verify your mobile number");
          $(".error").css("display", "block");
        } else if (result.status == "blocked") {
          $('label[for="enquiry_mobile"]').html("Your mobile no is blocked as you have reached maximum attempt limit for otp verification");
          $(".error").css("display", "block");
        } else if (result.status == "success") {
          $.fancybox.close(true);
          $('#memberEnquiryForm')[0].reset();

          swal({
            title: "Successful",
            icon: "success",
            text: "Thank you for your enquiry"
          });
        } else {
          $.each(result, function(i, v) {
            $('label[for="'+i+'"]').html(v);
          });
          var keys = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + keys[0] + '"]').focus()
        }
      }
    });
    
  });

  $("#memberEnquiryLoginForm").on("submit", function(e) {
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var formdata = $(this).serialize();
    
    $.ajax({
      type: 'POST',
      data:formdata,
      url: CI_ROOT + "member/enquiryLoginAction",
      dataType: "json",
      beforeSend: function() {
        $("#preloader").show();
        $("#status").show()
      },

      success: function(result) {
        $("#preloader").hide();
        $("#status").fadeOut();

        if (result.status == "success") {
          $.fancybox.close(true);
          $('#memberEnquiryLoginForm')[0].reset();

          swal({
            title: "Successful",
            icon: "success",
            text: "Thank you for your enquiry"
          });
        } else {
          $.each(result, function(i, v) {
            $('label[for="'+i+'"]').html(v);
          });
          var keys = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + keys[0] + '"]').focus()
        }
      }
    });
    
  });
});