$('.slider').slick({
  slidesToShow: 1,
  slidesToScroll: 1,
  autoplay:true,
  autoplaySpeed: 2000,
  speed: 1500,
  arrows: false,
  dots:true,
});

$('.advtSlider').slick({
  dots: false,
  arrows: true,
  infinite: true,
  speed: 300,
  slidesToShow: 4,
  autoplay:true,
  slidesToScroll: 1,
  responsive: [
    {
      breakpoint: 1024,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 1

      }
    },
    {
      breakpoint: 600,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 1
      }
    },
    {
      breakpoint: 480,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1
      }
    }
  ]
});

$(document).ready(function(){
  $("[data-fancybox]").fancybox({
    afterClose: function( instance, slide ) {
      $(".error").html("");
      $(".error").css("display","none");
      $('#sub_email').val("");
      $('#tradeEnquiryForm')[0].reset();
    }
  });

  $("#newsletter_subscribe").on("click",function(e){
    e.preventDefault();        
    $(".error").html("");
    $(".error").css("display","none");
    
    var sub_email = $("#sub_email").val();
    
    $.ajax({
      type:'POST',
      data:{sub_email:sub_email},
      url:CI_ROOT+"newsletter/newsletterAction",
      dataType: "json",
      beforeSend:function(){
				$("#preloader").show(); 
			},
      success:function(result){
        $("#preloader").hide(); 
        if(result.status == "success"){
          $('#sub_email').val("");
          $.fancybox.close(true);
          swal({
            title: "Thank You !",
            icon: "success",
            text: "You are successfully subscribed for Newsletter."
          });
        }else if(result.sub_email == "required"){
          // $('#sub_email').val("");
          $("label[for='sub_email']").html("Email is required.");
          $(".error").css("display","block");
        }else if(result.sub_email == "invalid"){
          // $('#sub_email').val("");
          $("label[for='sub_email']").html("Email is invalid.");
          $(".error").css("display","block");
        }else if(result.sub_email == "exist"){
          // $('#sub_email').val("");
          $("label[for='sub_email']").html("Email already exist.");
          $(".error").css("display","block");
        }
      }
    });
  });

  $("#tradeEnquiryForm").on("submit",function(e){
    e.preventDefault();        
    $(".error").html("");
    $(".error").css("display","none");
    
    var formdata = $(this).serialize();

    $.ajax({
      type:'POST',
      data:formdata,
      url:CI_ROOT+"tradeenquiry/enquiryAction",
      dataType: "json",
      beforeSend:function(){
				$("#preloader").show(); 
        $("#status").show(); 
			},
      success:function(result){
        $("#preloader").hide(); 
        $("#status").fadeOut();

        if(result.status == "success"){
          $.fancybox.close(true);
          $('#tradeEnquiryForm')[0].reset();
          swal({
            title: "Thank You !",
            icon: "success",
            text: "We will contact you shortly."
          });
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          
          var keys = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + keys[0] + '"]').focus();
        }
      }
    });
  });
});



$(document).ready(function () {

    //select the POPUP FRAME and show it
    $("#home-popup").hide().fadeIn(1000);

    //close the POPUP if the button with id="close" is clicked
    $("#close").on("click", function (e) {
        e.preventDefault();
        $("#home-popup").fadeOut(1000);
    });

});
