var table, table_1;

$(document).ready(function(){
  table = $("#bsmTable").DataTable({
    "paging":   false,
    "scrollX": true,
    "scrollY": 400,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'bsm/getBsm',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0],"width":80},
      {"targets":[1],"width":100},
      {"targets":[2],"width":100},
      {"targets":[3],"width":200},
      {"targets":[4],"width":80},
      {"targets":[5,6],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });


  $("#add_bsm").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "bsm/addBsmAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $("#preloader").show();
      },
      success: function(result) {
      	$("#preloader").hide();
      	
        if(result.status == "success"){
          window.location.href = CI_ROOT + "bsm/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_bsm").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "bsm/updateBsmAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $("#preloader").show();
      },
      success: function(result) {
      	$("#preloader").hide();
      	
        if(result.status == "success"){
          window.location.href = CI_ROOT + "bsm/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
});