var table;
$(document).ready(function(){
  table = $("#businessTable").DataTable({
    "paging":   false,
    "scrollX": true,
    "scrollY": 400,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'business/getBusiness',
      "type": "POST"
    },
    "columnDefs": [
       { 
        "targets": [0,1,2,4,5,6,7],
        "orderable": false
      },
      {"targets":[0],"width":80},
      {"targets":[1],"width":150},
      {"targets":[2],"width":150},
      {"targets":[3],"width":150},
      {"targets":[4],"width":150},
      {"targets":[5],"width":150},
      {"targets":[6],"width":80},
      {"targets":[7,8],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });
  
  $("#add_business").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "business/addBusinessAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $("#preloader").show();
      },
      success: function(result) {
      	$("#preloader").hide();
      	
        if(result.status == "success"){
          window.location.href = CI_ROOT + "business/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_business").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "business/updateBusinessAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $("#preloader").show();
      },
      success: function(result) {
      	$("#preloader").hide();
        if(result.status == "success"){
          window.location.href = CI_ROOT + "business/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
});