var table, table_1;

$(document).ready(function(){
  table = $("#careersTable").DataTable({
    "paging":   false,
    "scrollX": true,
    "scrollY": 400,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'careers/getCareers',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0],"width":80},
      {"targets":[1],"width":150},
      {"targets":[2],"width":200},
      {"targets":[3],"width":80}, 
      {"targets":[5,4],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });

  table_1 = $("#jobApplication").DataTable({
    "paging":   true,
    "scrollX": true,
    "scrollY": false,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'careers/getJobApplication',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0],"width":80},
      {"targets":[1],"width":200},
      {"targets":[2],"width":200},
      {"targets":[3],"width":100},
      {"targets":[4],"width":150},
      {"targets":[5],"width":150}, 
      {"targets":[6],"width":120}
    ],
    dom: 'Bfrtip',
    buttons: []
  });
  
  $("#add_job").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    $('.contenteditor').each(function() {
      var name = $('.contenteditor').attr('name');
      CKEDITOR.instances[name].updateElement();
    });  

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "careers/addJobAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $("#preloader").show()
      },
      success: function(result) {
        if(result.status == "success"){
          $("#preloader").hide();
          window.location.href = CI_ROOT + "careers/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_job").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    $('.contenteditor').each(function() {
      var name = $('.contenteditor').attr('name');
      CKEDITOR.instances[name].updateElement();
    });  

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "careers/updateJobAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $("#preloader").show()
      },
      success: function(result) {
        if(result.status == "success"){
          $("#preloader").hide();
          window.location.href = CI_ROOT + "careers/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
});