var table;
$(document).ready(function(){
  table = $("#governmentTable").DataTable({
    "paging":   false,
    "scrollX": true,
    "scrollY": 400,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'government/getGovernment',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0],"width":80},
      {"targets":[1],"width":350},
      {"targets":[2],"width":100},
      {"targets":[3],"width":80},
      {"targets":[4,5],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });
  
  $("#add_government").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "government/addGovernmentAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $("#preloader").show()
      },
      success: function(result) {
        if(result.status == "success"){
          $("#preloader").hide();
          window.location.href = CI_ROOT + "government/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_government").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "government/updateGovernmentAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $("#preloader").show()
      },
      success: function(result) {
        if(result.status == "success"){
          $("#preloader").hide();
          window.location.href = CI_ROOT + "government/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
});