var table;
$(document).ready(function(){
  table = $("#nomineeTable").DataTable({
    "paging":   false,
    "scrollX": true,
    "scrollY": 500,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url": CI_ROOT+'nominees/getNominee',
      "type": "POST"
    },
    "columnDefs": [
      { 
        "targets": "_all",
        "orderable": false
      },
      {"targets":[0],"width":80},
      {"targets":[1],"width":100},
      {"targets":[2,3],"width":150},
      {"targets":[4],"width":80},
      {"targets":[5,6],"width":130}
    ],
    dom: 'Bfrtip',
    buttons: []
  });

  $("#add_nominee").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "nominees/addNomineesAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $("#preloader").show()
      },
      success: function(result) {
        if(result.status == "success"){
          $("#preloader").hide();
          window.location.href = CI_ROOT + "nominees/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
  
  $("#update_nominees").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = new FormData(this);
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "nominees/updateNomineeAction",
      mimeType: "multipart/form-data",
      contentType: !1,
      processData: !1,
      dataType: "json",
      beforeSend: function(){
        $("#preloader").show()
      },
      success: function(result) {
        if(result.status == "success"){
          $("#preloader").hide();
          window.location.href = CI_ROOT + "nominees/list";
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          var t = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
        }
      }
    })
  });
});