var table;
$(document).ready(function() {
  // Switchery
  var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
  $('.js-switch').each(function() {
      new Switchery($(this)[0], $(this).data());
  });

  table = $("#adminTable").DataTable({
    "paging":   true,
    "scrollX": true,
    "processing": true, 
    "serverSide": true, 
    "order": [],
    "ajax": {
      "url" : CI_ROOT + "admin/getAdminList",
      "type": "POST"
    },
    "columnDefs": [
      { "targets": [0], "width":80},
      { "targets": [1], "width":80},
      { "targets": [2], "width":100},
      { "targets": [3], "width":100},
      { "targets": [4], "width":100}
      // { "targets": [5], "width":200}
    ],
    dom: "Bfrtip",
    buttons: []
  }); 
    
  $("#add_admin").on("submit", function(e) {
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "admin/addAdminAction",
      dataType: "json",
      beforeSend: function() {
          $(".preloader").show()
      },
      success: function(response){
        if(response.status == "success"){
          $(".preloader").hide();
          window.location.href = CI_ROOT + "admin/list";
        }else if("invalid" == response.status){
          $(".preloader").hide();

          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(response, function(e, t) {
            $("label[for='"+e+"']").html(t);
          });
          
          var t = Object.keys(response);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
          $(".preloader").hide();
        }
      }
    })
  });
  
  $("#edit_admin").on("submit", function(e){
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "admin/editAdminAction",
      dataType: "json",
      beforeSend: function(){
        $(".preloader").show()
      },
      success: function(response) {
        if ("success" == response.status){
          $(".preloader").hide();
          window.location.href = CI_ROOT + "admin/list";
        }else if("invalid" == response.status){
          $(".preloader").hide();
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(response, function(e, t) {
            $("label[for='" + e + "']").html(t); 
          });
          
          var t = Object.keys(response);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
          $(".preloader").hide();
        }
      }
    });
  });

  $("#change_pass").on("submit", function(e) {
    e.preventDefault();
    $(".error").html("");
    $(".error").css("display", "none");

    var t = $(this).serialize();
    $.ajax({
      type: "POST",
      data: t,
      url: CI_ROOT + "admin/changePasswordAction",
      dataType: "json",
      beforeSend: function() {
        $(".preloader").show()
      },
      success: function(response) {
        if("success" == response.status){
          $(".preloader").hide();
          window.location.href = CI_ROOT + "admin/dashboard";
        }else if("invalid" == response.status){
          $(".preloader").hide();
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong."
          });
        }else{
          $.each(response, function(e, t) {
            $("label[for='" + e + "']").html(t); 
          });
          
          var t = Object.keys(response);
          $(".error").css("display", "block");
          $('input[name="' + t[0] + '"]').focus();
          $(".preloader").hide();
        }
      }
    });
  });
});