var product = '';
var cname = '';
var city = '';
var region = '';
var sort = '';

$(document).ready(function(){
  firstLoad();

  $("#searchForm").on("submit",function(e){
    e.preventDefault();        
    
    product = $("#product").val();
    cname = $("#cname").val();
    city = $("#city").val();
    region = $("#region").val();
    sort = $("#sort").val();
    var page = 1;

    $("#total").html('Please wait ....');
  
    $.ajax({
      type:'POST',
      data:{product : product,
      cname : cname,
      city : city,
      region : region,
      sort : sort,
      page : page},
      url:CI_ROOT+"member/getDirectorySearchData",
      dataType: "json",
      beforeSend:function(){
        $("#preloader").show(); 
        $("#status").show(); 
      },
      success:function(result){
        if(result.status == "success"){
          $("#member_content").html('');
          $("#pagination_link").html('');
          $("#total").html(result.total+' Members Found');
          $("#member_content").html(result.data);
          $("#pagination_link").html(result.pagination);
        }else if(result.status == "fail"){
          $("#member_content").html('');
          $("#pagination_link").html('');
          $("#total").html('0 Members Found');
        }
  
        $("#preloader").hide(); 
        $("#status").fadeOut();
      }
    });
  });

  $("input[type='reset']").closest('form').on('reset', function(event) {
    product = '';
    cname = '';
    city = '';
    region = '';
    sort = '';
    firstLoad();
  });
});

function firstLoad(){
  var page = '1';

  $("#total").html('Please wait ....');

  $.ajax({
    type:'POST',
    data:{product : product,
    cname : cname,
		city : city,
		region : region,
		sort : sort,
    page : page},
    url:CI_ROOT+"member/getDirectories",
    dataType: "json",
    beforeSend:function(){
      $("#preloader").show(); 
      $("#status").show(); 
    },
    success:function(result){
      if(result.status == "success"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html(result.total+' Members Found');
        $("#member_content").html(result.data);
        $("#pagination_link").html(result.pagination);
      }else if(result.status == "fail"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html('0 Members Found');
      }

      $("#preloader").hide(); 
      $("#status").fadeOut();
    }
  });
}

function paginate(page,e){
  $("#total").html('Please wait ....');

  if(page == "prev"){
    page = $(".activetxt").text();
    page = page - 1;
  }else if(page == "next"){
    page = $(".activetxt").text();
    page = page + 1;
  }

  $.ajax({
    type:'POST',
    data:{product : product,
    cname : cname,
    city : city,
    region : region,
    sort : sort,
    page : page},
    url:CI_ROOT+"member/getDirectories",
    dataType: "json",
    beforeSend:function(){
      $("#preloader").show(); 
      $("#status").show(); 
    },
    success:function(result){
      if(result.status == "success"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html(result.total+' Members Found');
        $("#member_content").html(result.data);
        $("#pagination_link").html(result.pagination);
      }else if(result.status == "fail"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html('0 Members Found');
      }

      $("#preloader").hide(); 
      $("#status").fadeOut();
    }
  });
}

function searchPaginate(page,e){
  product = $("#product").val();
  cname = $("#cname").val();
  city = $("#city").val();
  region = $("#region").val();
  sort = $("#sort").val();

  $("#total").html('Please wait ....');

  if(page == "prev"){
    page = $(".activetxt").text();
    page = page - 1;
  }else if(page == "next"){
    page = $(".activetxt").text();
    page = page + 1;
  }

  $.ajax({
    type:'POST',
    data:{product : product,
    cname : cname,
    city : city,
    region : region,
    sort : sort,
    page : page},
    url:CI_ROOT+"member/getDirectorySearchData",
    dataType: "json",
    beforeSend:function(){
      $("#preloader").show(); 
      $("#status").show(); 
    },
    success:function(result){
      if(result.status == "success"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html(result.total+' Members Found');
        $("#member_content").html(result.data);
        $("#pagination_link").html(result.pagination);
      }else if(result.status == "fail"){
        $("#member_content").html('');
        $("#pagination_link").html('');
        $("#total").html('0 Members Found');
      }

      $("#preloader").hide(); 
      $("#status").fadeOut();
    }
  });
}