var year;

$(document).ready(function(){
  year = $('.resp-tab-active').children().text();
  loadExhibitionData(year);

  $('.slider').slick({
    slidesToShow: 5,
    slidesToScroll: 1,
    arrows: false,
    dots:false,
  
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 5,
        }
      },
      {
        breakpoint: 600,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 400,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1
        }
      },
      {
        breakpoint: 320,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1
        }
      }
    ]
  });

  $('.next').click(function(){
    $('.slider').slick('slickPrev');
  })
  
  $('.previous').click(function(){
    $('.slider').slick('slickNext');
  })

  $('.slider li').click(function(){
		$('.slider li').removeClass('resp-tab-active');
    $(this).addClass('resp-tab-active');
    year = $(this).children().text();
    loadExhibitionData(year);
  });
  
  $('.radioBtn').click(function(){
    $('.radioBtn').removeClass('whiteColor');
    $(this).addClass('whiteColor');
  });

  $("#exhibitorEnquiryForm").on("submit",function(e){
    e.preventDefault();        
    $(".error").html("");
    $(".error").css("display","none");
    
    var formdata = $(this).serialize();

    $.ajax({
      type:'POST',
      data:formdata,
      url:CI_ROOT+"exhibitions/enquiryAction",
      dataType: "json",
      beforeSend:function(){
				$("#preloader").show(); 
        $("#status").show(); 
			},
      success:function(result){
        $("#preloader").hide(); 
        $("#status").fadeOut();

        if(result.status == "success"){
          $.fancybox.close(true);
          $('#exhibitorEnquiryForm')[0].reset();
          swal({
            title: "Thank You !",
            icon: "success",
            text: "We will contact you shortly."
          });
        }else{
          $.each(result, function(e, t) {
            $("label[for='" + e + "']").html(t)
          });
          
          var keys = Object.keys(result);
          $(".error").css("display", "block");
          $('input[name="' + keys[0] + '"]').focus();
        }
      }
    });
  });
});

function loadExhibitionData(year){
  $.ajax({
    type: "POST",
    data: {year:year},
    url: CI_ROOT + "exhibitions/getExhibitionData",
    dataType: "json",
    beforeSend:function(){
      $("#preloader").show(); 
      $("#status").show(); 
    },
    success:function(result){  
      $("#preloader").hide(); 
      $("#status").fadeOut();

      if(result.status == "success"){
        $("#responseData").html('');
        $("#responseData").html(result.response);
      }else if(result.status == "fail"){
        $("#responseData").html('<h2 class="pt-4" style="color:#ccc">Data Not Available.</h2>');
      }else{
        $("#responseData").html('<h2 class="pt-4" style="color:#ccc">Data Not Available.</h2>');
      } 
    }
  });
}

function show(ref,e){
  $(".error").html("");
  $(".error").css("display","none");  
  $('#exhibitorEnquiryForm')[0].reset();
  $("#exhibition").val(ref);
  $("#exhibition").prop("readonly", true);
}