$(document).ready(function(){
  $("#resendOtp").hide();
  $("#otpTxt").hide();

  $("#generateOtp").on("click",function(e){
    e.preventDefault();        
    $(".error").html("");
    $(".error").css("display","none");

    var mobile = $("#mobile").val();
    var isd = $("#isd").val();

    if(mobile !== '' && isd !== ''){
      $.ajax({
        type:'POST',
        data:{mobile:mobile,isd:isd},
        url:CI_ROOT+"member/generateOtp",
        dataType: "json",
        beforeSend:function(){
          $("#preloader").show(); 
          $("#status").show(); 
        },
        success:function(result){
          $("#preloader").hide(); 
          $("#status").fadeOut();

          if(result.status == "success"){
            $("#resendOtp").show();
            $("#otpTxt").show();
            $("#generateOtp").hide();
          }else if(result.status == "error"){
            swal({
              title: "Error",
              icon: "error",
              text: result.msg
            });
          }else if(result.status == "invalid"){
            swal({
              title: "Invalid Request!",
              icon: "error",
              text: "Something went wrong ! Please try again."
            });
          }else if(result.status == "blocked"){
            swal({
              title: "Blocked",
              icon: "error",
              text: "Your mobile no is blocked as you have reached maximum attempt limit for otp verification."
            });
          }else{
            $.each(result, function(i, v){
              $("label[for='"+i+"']").html(v);
            });
                      
            var keys = Object.keys(result);
            $(".error").css("display","block");
            $('input[name="'+keys[0]+'"]').focus();
          }
        }
      });
    }else if(mobile == ''){
      $("label[for='mobile']").html("mobile number is required.");
      $(".error").css("display","block");
      $('input[name="mobile"]').focus();
    }else if(isd == ''){  
      $("label[for='isd']").html("required.");
      $(".error").css("display","block");
      $('select[name="isd"]').focus(); 
    }
  }); 

  $("#resendOtp").on("click",function(e){
    e.preventDefault();        
    $(".footer_error").html("");
    $(".footer_error").css("display","none");

    var mobile = $("#mobile").val();
    var isd = $("#isd").val();

    if(mobile !== '' && isd !== ''){
      $.ajax({
        type:'POST',
        data:{mobile:mobile,isd:isd},
        url:CI_ROOT+"member/generateOtp",
        dataType: "json",
        beforeSend:function(){
          $("#preloader").show(); 
          $("#status").show();  
        },
        success:function(result){
          $("#preloader").hide(); 
          $("#status").fadeOut();

          if(result.status == "success"){
            $("#resendOtp").show();
            $("#otpTxt").show();
            $("#generateOtp").hide();
          }else if(result.status == "error"){
            swal({
              title: "Error",
              icon: "error",
              text: result.msg
            });
          }else if(result.status == "invalid"){
            swal({
              title: "Invalid Request!",
              icon: "error",
              text: "Something went wrong ! Please try again."
            });
          }else if(result.status == "blocked"){
            swal({
              title: "Blocked",
              icon: "error",
              text: "Your mobile no is blocked as you have reached maximum attempt limit for otp verification."
            });
          }else{
            $.each(result, function(i, v){
              $("label[for='"+i+"']").html(v);
            });
                      
            var keys = Object.keys(result);
            $(".error").css("display","block");
            $('input[name="'+keys[0]+'"]').focus();
          }
        }
      });
    }else if(mobile == ''){
      $("label[for='mobile']").html("Mobile is required.");
      $(".error").css("display","block");
      $('input[name="mobile"]').focus();
    }else if(isd == ''){  
      $("label[for='isd']").html("Required.");
      $(".error").css("display","block");
      $('select[name="isd"]').focus(); 
    }
  }); 

  $("#memberLoginForm").on("submit",function(e){
    e.preventDefault();        
    $(".error").html("");
    $(".error").css("display","none");

    var formdata = $(this).serialize();
    
    $.ajax({
      type:'POST',
      data:formdata,
      url:CI_ROOT+"member/loginAction",
      dataType: "json",
      beforeSend:function(){
				$("#preloader").show(); 
				$("#status").show(); 
			},
      success:function(result){
        $("#preloader").hide(); 
        $("#status").fadeOut();
        
        if(result.status == "success"){
          window.location.href = result.url;
        }else if(result.status == "invalid"){
          swal({
            title: "Invalid Request!",
            icon: "error",
            text: "Something went wrong ! Please try again."
          });
        }else if(result.status == "otp_missing"){
          if($("#otpTxt").is(":visible")){
            $("label[for='otp']").html('Please enter otp');
            $(".error").css("display","block");
            $("input[name='otp']").focus();
          }else{
            swal({
              title: "Verify Mobile",
              icon: "error",
              text: "Please verify your mobile number by clicking Generate OTP."
            });
          }
        }else if(result.status == "blocked"){
          swal({
            title: "Blocked",
            icon: "error",
            text: "Your mobile number is blocked as you have reached maximum attempt limit for otp verification."
          });
        }else if(result.status == "invalid_member"){
          swal({
            title: "Invalid",
            icon: "error",
            text: "Username & Password does not match"
          });
        }else{
          $.each(result, function(i, v) {
            $("label[for='"+i+"']").html(v);
          });
                    
          var keys = Object.keys(result);
          $(".error").css("display","block");
          $('input[name="'+keys[0]+'"]').focus();
        }
      }
    });
  });
});